/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityConfDaoImpl
extends JdbcTemplateDaoSupport<ActivityConf>
implements ActivityConfDao {
    private static final Logger logger = LoggerFactory.getLogger(ActivityConfDaoImpl.class);

    public ActivityConfDaoImpl() {
        super(ActivityConf.class);
    }

    @Override
    public Map<Long, ActivityConf> getConfigMapByActivityIds(Collection<Long> activityIds) {
        if (GenericsUtils.isNullOrEmpty(activityIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, ActivityConf> retMap = new HashMap<Long, ActivityConf>();
        SingleSqlBuilder sb = this.createSqlBuilder(new String[0]);
        sb.in("activityId", activityIds);
        List queryList = this.queryList(sb);
        if (queryList != null && queryList.size() > 0) {
            for (ActivityConf conf : queryList) {
                retMap.put(conf.getActivityId(), conf);
            }
        }
        return retMap;
    }

    @Override
    public void saveActivityConf(ActivityConf activityConfig) {
        super.save((Object)activityConfig, new String[0]);
    }

    @Override
    public void updateActivityConf(ActivityConf activityConf) {
        super.update((Object)activityConf, new String[0]);
    }

    @Override
    public ActivityConf getConfigByActivityId(long activityId) {
        Map<Long, ActivityConf> map = this.getConfigMapByActivityIds(Arrays.asList(activityId));
        if (map != null && map.get(activityId) != null) {
            return map.get(activityId);
        }
        return null;
    }
}

