package com.baijia.tianxiao.util.sqlBuilder;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import com.baijia.tianxiao.sqlbuilder.util.VariableChangeUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author weihongyan
 * @description 针对sql-builder的po生成批量insert工具.FIXME 有sql注入风险,慎用! 
 * @date 26/12/2016
 */
@Slf4j
@Deprecated // sql-builder 有类似的功能,比这个完善,这个太垃圾了.
public class BatchInsertSqlCreator<PO> {

    private static final String split = "'";
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");

    private Class<PO> clazz;
    private String catalog;
    private String tableName;
    private List<? extends PO> poList;
    private List<String> insertProps;
    private List<String> convertProps;

    public BatchInsertSqlCreator(List<? extends PO> poList, String... props) {
        try {
            Preconditions.checkArgument(CollectionUtils.isNotEmpty(poList), "the poList canot be null or empty!");
            this.poList = poList;
            this.clazz = (Class<PO>) poList.get(0).getClass();
            Preconditions.checkArgument(clazz.isAnnotationPresent(Table.class),
                "this is not a sql-builder po list!(no @Table annotation)");
            this.catalog = clazz.getAnnotation(Table.class).catalog();
            this.tableName = clazz.getAnnotation(Table.class).name();
            this.tableName = StringUtils.isNotEmpty(tableName) ? tableName : clazz.getAnnotation(Entity.class).name();
            Preconditions.checkArgument(StringUtils.isNotEmpty(catalog) && StringUtils.isNotEmpty(tableName),
                "no catalog or tableName");
            this.insertProps = getAllPOProps(props);
            Preconditions.checkArgument(CollectionUtils.isNotEmpty(this.insertProps),
                "read props failed! no field is annotationed with @Column or @Id");
            convertProps = convertToSqlProps(insertProps);
        } catch (Exception e) {
            log.error("BatchInsertSqlCreator initialize failed, exception is:{}", e);
            throw e;
        }
    }

    @SneakyThrows
    private List<String> convertToSqlProps(List<String> insertProps) {
        List<String> convertProps = Lists.newArrayList();
        for (String prop : insertProps) {
            Field field = clazz.getDeclaredField(prop);
            if (field.isAnnotationPresent(Id.class)) {
                convertProps.add(prop);
            } else if (field.isAnnotationPresent(Column.class)) {
                String temp = field.getAnnotation(Column.class).name();
                convertProps.add(StringUtils.isNotEmpty(temp) ? temp : VariableChangeUtils.camelToUnderline(prop));
            }
        }
        return convertProps;
    }

    @SneakyThrows
    private List<String> getAllPOProps(String... props) {
        List<String> allProps = Lists.newArrayList();
        if (props.length > 0) {
            for (String prop : props) {
                Field field = clazz.getDeclaredField(prop);
                if (field.isAnnotationPresent(Column.class) || field.isAnnotationPresent(Id.class)) {
                    allProps.add(field.getName());
                }
            }
        } else {
            Field[] fields = clazz.getDeclaredFields();
            for (Field field : fields) {
                if (field.isAnnotationPresent(Column.class) || field.isAnnotationPresent(Id.class)) {
                    allProps.add(field.getName());
                }
            }
        }
        return allProps;
    }

    public String toSql() {
        String insertSql = createInsertHead();
        String valueSql = createValueBody();
        return insertSql + valueSql;
    }

    @SneakyThrows
    private String createValueBody() {
        Map<String, Field> fieldMap = // cache
            CollectorUtil.collectMap(Lists.newArrayList(clazz.getDeclaredFields()), new Function<Field, String>() {
                @Override public String apply(Field input) {
                    input.setAccessible(true);
                    return input.getName();
                }
            });

        List<List<String>> valueList = Lists.newArrayList();
        for (PO po : poList) {
            List<String> values = Lists.newArrayList();
            Field field = null;
            Object value = null;
            for (String prop : insertProps) {
                field = fieldMap.get(prop);
                value = field.get(po);
                if (value instanceof Date) {
                    values.add(null == value ? null : split + format.format(value) + split);
                } else {
                    values.add(null == value ? null : split + value.toString()//这里的转义 能避免sql注入????
                        .replace("\\", "\\\\")
                        .replace("'", "\\'") + split);
                }
            }
            valueList.add(values);
        }

        String valueSql = valueList.toString().replace("[", "(").replace("]", ")");
        valueSql = valueSql.substring(1, valueSql.length() - 1);
        return valueSql;
    }

    private String createInsertHead() {
        StringBuilder insertSql = new StringBuilder("INSERT INTO ");
        insertSql.append(catalog);
        insertSql.append(".");
        insertSql.append(tableName);
        insertSql.append(" ");
        insertSql.append(convertProps.toString().replace("[", "(").replace("]", ")"));
        insertSql.append(" VALUES ");
        return insertSql.toString();
    }
}