package com.baijia.tianxiao.dal.wx.constant;

import com.baijia.tianxiao.constants.signup.PayResult;
import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.Collection;
import java.util.List;

/**
 * 网校订单状态
 * Created by wangsixia on 2017/1/11.
 */
public enum WxOrderStatus {

    ALL(0, ""),

    FINISH(1, "已完成"),

    NOT_PAY(2, "待支付"),

    CANCEL(3, "已取消"),

    // C端无待报名状态,B端可能有
    //NOT_SIGNUP(4, "待报名"),

    ;
    @Getter
    private int code;
    @Getter
    private String msg;

    private WxOrderStatus(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    // 已完成订单
    private static List<Integer> FINISH_ORDER = Lists.newArrayList(PayResult.SUCCESS.getCode());
    // 待支付订单
    private static List<Integer> NOT_PAY_ORDER = Lists.newArrayList(PayResult.FAIL.getCode(), PayResult.IN_PROGRESS.getCode());

    /**
     * 根据查询条件状态转换订单支付状态
     * @param status
     * @return
     */
    public static Collection<Integer> getPurchaseStatus(Integer status) {
        if (status != null) {
            if (status == FINISH.getCode()) {
                return  FINISH_ORDER;
            } else if (status == NOT_PAY.getCode()) {
                return NOT_PAY_ORDER;
            }
        }
        return null;
    }

    /**
     * 返回转换后的订单状态
     * @param status
     * @return
     */
    public static Integer getOrderStatus(Integer status) {
        if (status == PayResult.SUCCESS.getCode()) {
            return FINISH.getCode();
        } else {
            return NOT_PAY.getCode();
        }
    }
}
