/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;

import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**   
 * @title       : OrgWechatMediaNews 
 * @description : 微信永久素材 - 图文
 * @author      : zhenyujian
 * @date        : 2015年12月24日 上午11:40:58 
 */
@Entity
@Table(name = "org_wechat_media_news", catalog = "yunying")
@Data
public class OrgWechatMediaNews {
	
	@Id
	@GeneratedValue
	private Integer id;
	
	@Column(name="authorizer_app_id")
    private String authorizerAppId; //微信公众号id
	
	@Column(name="media_id")
    private String mediaId; //微信素材id
	
	@Column(name="wechat_update_time")
    private Date wechatUpdateTime;//微信记录的素材最后更新时间
	
	@Column(name="json")
    private String json;//json内容
	
	@Column(name="create_time")
    private Date createTime; //创建时间
	
	@Column(name="update_time")
    private Date updateTime; //更新时间
	
	@Column(name="type")
	private Integer type;//素材类型  com.baijia.tianxiao.dal.wechat.constant.WechatMediaNewsType
    
    
    
    
//    private String title; //标题
//    private String thumbMediaId; //图文消息的封面图片素材id（必须是永久mediaID）
//    private String thumbMediaUrl; //图文消息的封面图片素材url
//    private String author; //作者
//    private String digest; //摘要
//    private Integer showCoverPic; //是否显示封面，0为false，即不显示，1为true，即显示
//    private String content; //内容
//    private String contentSourceUrl; //原文访问地址
}

