/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;

import java.util.Date;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import lombok.Data;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

@Entity
@Table(name = "org_wechat_custom_menu", catalog = "yunying")
@Data
public class OrgWechatCustomMenu {
	
	
	@Id
    @GeneratedValue
    private Integer id;

	@Column(name="authorizer_app_id")
    private String authorizerAppId; //微信公众号id
	
	@Column(name="json")
    private String json; //公众号菜单json
	
	@Column(name = "create_time")
    private Date createTime;
	
	@Column(name = "update_time")
	private Date updateTime;


    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}

