/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;

import java.util.Date;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

@Entity
@Table(name = "org_wechat_custom_activity", catalog = "yunying")
@Data
public class OrgWechatCustomActivity {

    @Id
    @GeneratedValue
    private Integer id;

    @Column(name = "authorizer_app_id")
    private String authorizerAppId; // 微信公众号id

    @Column(name = "activity_id")
    private Integer activityId;

    @Column(name = "activity_type")
    private Integer activityType;

    @Column(name = "qr_code_url")
    private String qrCodeUrl;

    @Column(name = "title")
    private String title;

    @Column(name = "description")
    private String description;

    @Column(name = "pic_url")
    private String picUrl;

    @Column(name = "create_time")
    private Date createTime;

    // 新加的字段
    @Column(name = "key_word")
    private String keyWrod;
    @Column(name = "replace_org_id")
    private Integer replaceOrgId;
    @Column(name = "origin_org_id")
    private Integer originOrgId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

}
