/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;


import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import lombok.Data;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;


/**   
 * @title       : Fans 
 * @description : http://mp.weixin.qq.com/wiki/17/c807ee0f10ce36226637cebf428a0f6d.html
 * @author      : zhenyujian
 * @date        : 2015年12月5日 下午4:57:37 
 */
@Entity
@Table(name = "org_wechat_fans", catalog = "yunying")
@Data
public class Fans {
	
	@Id
	@GeneratedValue
	private Integer id;
	
	@Column(name="authorizer_app_id")
	private String authorizerAppId;
	
	@Column(name="open_id")
	private String openId;//服务号可见用户id
	
	@Column(name="subscribe")
	private Integer subscribe;//是否关注了服务号 见 constant.WechatSubscribe
	
	@Column(name="last_communication_time")
	private Date lastCommunicationTime;//最后一次交互时间
	
	@Column(name="nick")
	private String nick;//微信昵称
	
	@Column(name="remark")
	private String remark;//备注名
	
	@Column(name="head_img_url")
	private String headImgUrl;//微信头像、
	
	@Column(name="sex")
	private Integer sex; //见 constant.WechatSex
	
	@Column(name="language")
	private String language; //语言
	
	@Column(name="city")
	private String city; //城市
	
	@Column(name="province")
	private String province; //省份
	
	@Column(name="country")
	private String country; //国家
	
	@Column(name="subscribe_time")
	private Date subscribeTime; //关注时间
	
	@Column(name="groug_id")
	private Integer groupId; //微信分组
	
	@Column(name="create_time")
	private Date createTime;
	
	@Column(name="update_time")
	private Date updateTime;
	
	@Column(name="is_del")
	private Integer isDel;
	
	@Column(name="head_img_url_gsx")
	private String headImgUrlGsx;//微信头像 (跟谁学url)

	@Column(name="longitude")
	private Double longitude;//经度

	@Column(name="latitude")
	private Double latitude;//维度

	@Column(name="default_org_number")
	private Integer defaultOrgNumber=0;//粉丝默认地理位置近的校区
	
	
	/**
	 * @Description  : 
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月9日 上午12:36:21 
	 *
	 * @Return       : void
	 */
	public void initBasicAttribute(){
		Date now = new Date();
		this.createTime = now;
		this.updateTime = now;
		this.isDel = DeleteStatus.NORMAL.getValue();
		if(this.groupId==null){
			groupId = -1;
		}
		if(this.remark==null){
			this.remark = "";
		}
		if(this.language==null){
			this.language="";
		}
		if(this.subscribe==null){
			this.subscribe=0;
			this.subscribeTime = new Date(0);
		}
		if(this.headImgUrlGsx==null){
			this.headImgUrlGsx="";
		}
		this.lastCommunicationTime = this.subscribeTime;
	}
	
	
	
	/**
	 * @Description  : 前端展示名称
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月8日 下午9:26:07 
	 *
	 * @Return       : String
	 */
	public String getShowName(){
		if(StringUtils.isNotBlank(remark)){
			return remark;
		}
		return nick;
	}
	
	
	
	/**
	 * @Description  : 是否允许聊天 （48小时内存在交互 允许聊天）
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月8日 下午9:25:41 
	 *
	 * @Return       : boolean
	 */
	public boolean isAllowToChat(){
		if(this.lastCommunicationTime!=null){
			Date now = new Date();
			long diff = now.getTime()/1000 - this.lastCommunicationTime.getTime()/1000;
			if(diff>=0 && diff<60*60*48){
				return true;
			}
		}
		return false;
	}
	
	
	
	/**
	 * @Description  : 更新指定字段信息 
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月7日 下午3:01:10 
	 *
	 * @Return       : void
	 */
	public void refreshBy(Fans newFans){
		this.setCity( newFans.getCity() );
		this.setCountry( newFans.getCountry() );
		this.setGroupId( newFans.getGroupId() );
		this.setHeadImgUrl( newFans.getHeadImgUrl() );
		this.setLanguage( newFans.getLanguage() );
		this.setNick( newFans.getNick() );
		this.setProvince( newFans.getProvince() );
		this.setRemark( newFans.getRemark() );
		this.setSex( newFans.getSex() );
		this.setSubscribeTime( newFans.getSubscribeTime());
		this.setSubscribe( newFans.getSubscribe());
		this.setHeadImgUrlGsx( newFans.getHeadImgUrlGsx());
		this.setLatitude(newFans.getLatitude());
		this.setLongitude(newFans.getLongitude());
		this.setDefaultOrgNumber(newFans.getDefaultOrgNumber());
		this.setUpdateTime(new Date());
	}
	
	
	public boolean isSubscribed(){
		if(this.subscribe!=null && this.subscribe.equals(1)){
			return true;
		}
		return false;
	}
	
	public String getHeadImgUrl(){
		if(StringUtils.isNoneBlank(this.headImgUrlGsx)){
			return this.headImgUrlGsx;
		}
		return this.headImgUrl;
	}
	
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}

