/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;

import java.util.Date;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.baijia.tianxiao.dal.wechat.constant.WechatAppServiceType;
import com.baijia.tianxiao.dal.wechat.constant.WechatAppVerifyType;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

@Entity
@Table(name = "org_wechat_authorizer_info", catalog = "yunying")
@Data
public class AuthorizerInfo {

    @Id
    @GeneratedValue
    private Integer id;

    @Column(name = "org_id")
    private Integer orgId;

    @Column(name = "nick_name")
    private String nickName;

    @Column(name = "head_img")
    private String headImg;

    @Column(name = "user_name")
    private String userName;

    @Column(name = "alias")
    private String alias;

    @Column(name = "qrcode_url")
    private String qrcodeUrl;

    @Column(name = "qrcode_storage_id")
    private Integer qrcodeStorageId;

    @Column(name = "service_type")
    private Integer serviceType;// 0代表订阅号，1代表由历史老帐号升级后的订阅号，2代表服务号

    // https://open.weixin.qq.com/cgi-bin/showdocument?action=dir_list&t=resource/res_list&verify=1&id=open1419318587&token=&lang=zh_CN
    // http://mp.weixin.qq.com/wiki/8/71e1908fa08e67c6251ebdd78fd6b6b4.html
    @Column(name = "verify_type")
    private Integer verifyType;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "authorizer_app_id")
    private String authorizerAppId;

    @Column(name = "fans_sync_status")
    private Integer fansSyncStatus; // com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus

    @Column(name = "media_news_sync_status")
    private Integer mediaNewsSyncStatus;

    // 数据传输字段,不对应表字段
    private Integer orgWechatType = 0; // 0:独立 1:使用公共账号

    // 是否通过了资质认证
    public boolean isPassedVerify() {
        return WechatAppVerifyType.isPassedVerify(verifyType);
    }

    // 是否是服务号
    public boolean isServiceApp() {
        return WechatAppServiceType.isServiceApp(serviceType);
    }

    // public Map<Integer,Boolean> mapFunc(){
    // Map<Integer,Boolean> funcMap = new HashMap<Integer,Boolean>();
    // boolean passedVerify = WechatAppVerifyType.isPassedVerify(verifyType);
    // boolean isServiceApp = WechatAppServiceType.isServiceApp(serviceType);
    //
    // if(!passedVerify && !isServiceApp){
    // //未通过认证的订阅号
    // funcMap.put(key, true);
    // }if(passedVerify && !isServiceApp){
    // //通过认证的订阅号
    // }if(!passedVerify && isServiceApp){
    // //未通过认证的服务号
    // }if(!passedVerify && !isServiceApp){
    // //通过认证的服务号
    // }
    // }

    public boolean hasWebAuthPermission() {
        if (isServiceApp() && isPassedVerify()) {
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}
