/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

@Entity
@Table(name = "org_wechat_authorization_info", catalog = "yunying")
@Data
public class AuthorizationInfo {

    @Id
    @GeneratedValue
    private Integer id;

    @Column(name = "org_id")
    private Integer orgId;

    @Column(name = "authorizer_app_id")
    private String authorizerAppId;

    @Column(name = "authorizer_access_token")
    private String authorizerAccessToken;

    @Column(name = "authorizer_refresh_token")
    private String authorizerRefershToken;

    @Column(name = "expires_in")
    private Integer expiresIn;// 单位秒

    @Column(name = "funcs")
    private String funcs;

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    // 数据传输字段,不对应表字段
    private Integer orgWechatType = 0; // 0:独立 1:使用公共账号
    private Integer masterOrgId; // 对应的主账号的orgId

    public boolean isAccessTokenExpired() {
        Date now = new Date();
        if ((now.getTime() / 1000 - updateTime.getTime() / 1000) > (expiresIn * 2 / 3)) {// 取有效时长的2/3避免边界问题
            return true;
        }
        return false;
    }

    public void setFuncsByList(List<Integer> funcsList) {
        if (funcsList != null && !funcsList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Integer id : funcsList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }

            this.funcs = sb.toString();

        }
    }

    public boolean hasFunc(Integer func) {
        if (func == null || StringUtils.isBlank(this.funcs)) {
            return false;
        }
        if (String.format(",%s,", this.funcs).contains(String.format(",%s,", func))) {
            return true;
        } else {
            return false;
        }
    }

    public boolean isUseMaster() {
        return this.orgWechatType == 1 ? true : false;
    }

    public Integer findReallyOrgId() {
        return this.isUseMaster() ? this.masterOrgId : this.orgId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

}
