
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.wechat.dao.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 21, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Repository
@Slf4j
public class UnifiedWechatAccountDaoImpl extends JdbcTemplateDaoSupport<UnifiedWechatAccount>
    implements UnifiedWechatAccountDao {

    @Override
    public List<UnifiedWechatAccount> listAllCampusWithAnyOneOrgInfo(Long orgId, boolean isOrgId) {
        SingleSqlBuilder<UnifiedWechatAccount> singleBuilder = this.createSqlBuilder();
        String sqlSelect = singleBuilder.toSql();
        UnifiedWechatAccount findUnifiedWechatRecordWithOrgId =
            this.findUnifiedWechatRecord(orgId, isOrgId, DeleteStatus.NORMAL.getValue());
        if (findUnifiedWechatRecordWithOrgId == null) {
            return GenericsUtils.emptyList();
        }
        log.info("findUnifiedWechatRecordWithOrgId is :{} ", findUnifiedWechatRecordWithOrgId);
        Long masterOrgId = orgId;
        if (findUnifiedWechatRecordWithOrgId.getMasterOrgId().intValue() != 0) {
            masterOrgId = findUnifiedWechatRecordWithOrgId.getMasterOrgId().longValue();
        }
        Map<String, Object> paramMaps = Maps.newHashMap();
        paramMaps.put("masterOrgId", masterOrgId);
        String sql = sqlSelect
            + " where del_status = 0 and  (master_org_id = :masterOrgId or org_id =:masterOrgId) order by create_time desc";
        log.info("querySql is :{} and paramMap is :{} ", sql, paramMaps);
        List<UnifiedWechatAccount> query = this.getNamedJdbcTemplate().query(sql, paramMaps,
            new BeanPropertyRowMapper<UnifiedWechatAccount>(UnifiedWechatAccount.class));
        query = GenericsUtils.isNullOrEmpty(query) ? GenericsUtils.<UnifiedWechatAccount> emptyList() : query;
        return query;
    }

    @Override
    public UnifiedWechatAccount findUnifiedWechatRecord(Long orgId, boolean isOrgId, Integer delStatus) {
        List<UnifiedWechatAccount> findUnifiedWechatRecords =
            this.findUnifiedWechatRecords(Arrays.asList(orgId), isOrgId, delStatus);
        return GenericsUtils.isNullOrEmpty(findUnifiedWechatRecords) ? null : findUnifiedWechatRecords.get(0);
    }

    @Override
    public List<UnifiedWechatAccount> findUnifiedWechatRecords(Collection<Long> ordIds, boolean isOrgId,
        Integer delStatus) {
        SingleSqlBuilder<UnifiedWechatAccount> singleBuilder = this.createSqlBuilder();
        singleBuilder.in(isOrgId ? "orgId" : "orgNumber", ordIds);
        if (delStatus != null) {
            singleBuilder.eq("delStatus", delStatus);
        }
        List<UnifiedWechatAccount> queryList = this.queryList(singleBuilder);
        queryList =
            GenericsUtils.isNullOrEmpty(queryList) ? GenericsUtils.<UnifiedWechatAccount> emptyList() : queryList;
        return queryList;
    }

    /**
     * 将所有使用了该主账号公众号的分校区机构全部置为删除状态
     */
    @Override
    public void deleteByOrgId(Long orgId) {
        log.info("del record with orgId:{} ", orgId);
        String sql =
            "update yunying.tx_unified_wechat_account set del_status = 1 , init_status = -1 where  master_org_id = :orgId";
        Map<String, Object> paramMaps = Maps.newHashMap();
        paramMaps.put("orgId", orgId);
        this.getNamedJdbcTemplate().update(sql, paramMaps);
        sql = "update yunying.tx_unified_wechat_account set del_status = 1, init_status = -1  where org_id =:orgId";
        this.getNamedJdbcTemplate().update(sql, paramMaps);
    }

    @Override
    public void deleteSlaveCampusByOrgId(Long slaveCampusOrgId) {
        log.info("del slaveCampus with orgId:{} ", slaveCampusOrgId);
        String sql = "update yunying.tx_unified_wechat_account set del_status = 1 where  org_id = :orgId";
        Map<String, Object> paramMaps = Maps.newHashMap();
        paramMaps.put("orgId", slaveCampusOrgId);
        this.getNamedJdbcTemplate().update(sql, paramMaps);
    }

    @Override
    public UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId(Integer orgId, Boolean isInit) {
        UnifiedWechatAccount findUnifiedWechatRecordWithOrgId =
            this.findUnifiedWechatRecord(orgId.longValue(), true, DeleteStatus.NORMAL.getValue());
        log.info("find UnifiedWechatAccount first :{} ", findUnifiedWechatRecordWithOrgId);
        if (findUnifiedWechatRecordWithOrgId == null) {
            return null;
        }
        SingleSqlBuilder<UnifiedWechatAccount> singleBuilder = this.createSqlBuilder();
        if (isInit != null) {
            Integer initStatus = isInit ? 0 : -1;
            singleBuilder.eq("initStatus", initStatus);
        }
        Integer masterOrgId = orgId;
        if (findUnifiedWechatRecordWithOrgId.getMasterOrgId() != 0) {
            masterOrgId = findUnifiedWechatRecordWithOrgId.getMasterOrgId();
        }
        singleBuilder.eq("orgId", masterOrgId);
        UnifiedWechatAccount ret = uniqueResult(singleBuilder);
        log.info("ret : {} ", ret);
        return ret;
    }

    @Override
    public boolean resetOrgWechatTypeIfNecessary(Integer masterOrgId) {
        if (masterOrgId == null) {
            return false;
        }
        SingleSqlBuilder<UnifiedWechatAccount> singleBuilder = this.createSqlBuilder();
        String sqlSelect = singleBuilder.toSql();
        String sql = sqlSelect + " where master_org_id =:masterOrgId and del_status = :status for update ";
        Map<String, Object> paramMaps = Maps.newHashMap();
        paramMaps.put("status", DeleteStatus.NORMAL.getValue());
        paramMaps.put("masterOrgId", masterOrgId);
        log.info("sql is :{} ", sql);
        List<UnifiedWechatAccount> queryResult = this.getNamedJdbcTemplate().query(sql, paramMaps,
            new BeanPropertyRowMapper<UnifiedWechatAccount>(UnifiedWechatAccount.class));
        log.info("query result is :{} ", queryResult);
        if (GenericsUtils.isNullOrEmpty(queryResult)) {
            log.info("queryResult is empty , need reset masterOrg :{} ", masterOrgId);
            this.deleteByOrgId(masterOrgId.longValue());
            return true;
        }
        return false;
    }

}
