/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.dao.SubscribeQRCodeDao;
import com.baijia.tianxiao.dal.wechat.po.SubscribeQRCode;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository()
public class SubscribeQRCodeDaoImpl extends JdbcTemplateDaoSupport<SubscribeQRCode> implements SubscribeQRCodeDao {

	public SubscribeQRCodeDaoImpl() {
		super(SubscribeQRCode.class);
	}

	@Override
	public SubscribeQRCode getQRCode(Integer orgId,String authorizerAppId) {
		SingleSqlBuilder<SubscribeQRCode> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("authorizerAppId", authorizerAppId);
        return uniqueResult(builder);
	}

}

