/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForSubscribeDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class OrgWechatReplyForSubscribeDaoImpl extends JdbcTemplateDaoSupport<OrgWechatReplyForSubscribe> implements OrgWechatReplyForSubscribeDao {

	public OrgWechatReplyForSubscribeDaoImpl() {
		super(OrgWechatReplyForSubscribe.class);
	}

	@Override
	public OrgWechatReplyForSubscribe getByAppId(String authorizerAppId) {
		SingleSqlBuilder<OrgWechatReplyForSubscribe> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        return uniqueResult(builder);
	}

}

