/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForKeywordDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class OrgWechatReplyForKeywordDaoImpl extends JdbcTemplateDaoSupport<OrgWechatReplyForKeyword> implements OrgWechatReplyForKeywordDao {

	public OrgWechatReplyForKeywordDaoImpl() {
		super(OrgWechatReplyForKeyword.class);
	}

	
	
	@Override
	public int count(String authorizerAppId) {
		SingleSqlBuilder<OrgWechatReplyForKeyword> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        builder.count("id");
        return queryForObject(builder, Integer.class);
	}

	
	
	@Override
	public List<OrgWechatReplyForKeyword> search(String authorizerAppId, PageDto pageDto) {
		final List<OrgWechatReplyForKeyword> list = new ArrayList<OrgWechatReplyForKeyword>();
		
		StringBuilder builder = new StringBuilder();
		builder.append("SELECT * FROM yunying.org_wechat_reply_for_keyword WHERE authorizer_app_id=:authorizerAppId ");

		builder.append(" ORDER BY id DESC");
		if( pageDto!=null ){
			builder.append(" LIMIT :start,:size");
		}
		
		
        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String,Object>();
        params.put("authorizerAppId", authorizerAppId);
        if( pageDto!=null ){
        	params.put("start", pageDto.firstNum());
        	params.put("size", pageDto.getPageSize());
        }
        
        template.query(builder.toString(), params, new RowMapper<Integer>() {
        	OrgWechatReplyForKeyword reply;
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
            	reply = new OrgWechatReplyForKeyword();
            	reply.setAuthorizerAppId( rs.getString("authorizer_app_id") );
            	reply.setContent( rs.getString("content") );
            	reply.setCreateTime( rs.getTimestamp("create_time") );
            	reply.setId( rs.getInt("id") );
            	reply.setKeywords( rs.getString("keywords") );
            	reply.setMediaId( rs.getString("media_id") );
            	reply.setMediaType( rs.getInt("media_type") );
            	reply.setUpdateTime( rs.getTimestamp("update_time") );
            	reply.setUrl( rs.getString("url") );
            	reply.setNote( rs.getString("note") );
            	list.add(reply);
                return 1;
            }
        });
        
        return list;
	}

}
