/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMediaNewsDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMediaNews;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**   
 * @title       : OrgWechatMediaNewsDaoImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年1月2日 下午11:00:20 
 */
@Repository
public class OrgWechatMediaNewsDaoImpl extends JdbcTemplateDaoSupport<OrgWechatMediaNews> implements OrgWechatMediaNewsDao{

	public OrgWechatMediaNewsDaoImpl() {
		super(OrgWechatMediaNews.class);
	}

	@Override
	public OrgWechatMediaNews getByMediaId(String authorizerAppId, String mediaId) {
		SingleSqlBuilder<OrgWechatMediaNews> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        builder.eq("mediaId", mediaId);
        return uniqueResult(builder);
	}

	
	
	@Override
	public void updateByMediaId(OrgWechatMediaNews mediaNews) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
	    //SQL
		StringBuilder builder = new StringBuilder();
		builder.append(" UPDATE yunying.org_wechat_media_news SET");
		builder.append("   json=:json");
		builder.append("   wechat_update_time=:wechatUpdateTime");
		builder.append("   update_time=:updateTime");
		builder.append(" WHERE authorizer_app_id=:authorizerAppId");
		builder.append(" AND media_id=:mediaId");
		
		//参数
		Map<String, Object> params = new HashMap<String,Object>();
		params.put("json", mediaNews.getJson());
		params.put("wechatUpdateTime", mediaNews.getWechatUpdateTime());
		params.put("updateTime", new Date());
        params.put("authorizerAppId", mediaNews.getAuthorizerAppId());
        params.put("mediaId", mediaNews.getMediaId());
        
        //执行
        template.update(builder.toString(), params);
	}

	
	
	@Override
	public void delByMediaIds(String authorizerAppId, List<String> mediaIds) {
		if(mediaIds==null || mediaIds.isEmpty()){
			return;
		}
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
		//SQL
		String sql = "DELETE FROM yunying.org_wechat_media_news WHERE authorizer_app_id=:authorizerAppId AND media_id IN (:mediaIds)";
		
		//参数
		Map<String, Object> params = new HashMap<String,Object>();
        params.put("authorizerAppId", authorizerAppId);
        params.put("mediaIds", mediaIds);
        
        //执行
        template.update(sql, params);
	}

	
	
	@Override
	public Map<String, Date> mapKeyMediaIdValueWechatUpdateTime(String authorizerAppId) {
		final Map<String, Date> map = new HashMap<String, Date>();
		
		String sql = "SELECT media_id,wechat_update_time FROM yunying.org_wechat_media_news WHERE authorizer_app_id=:authorizerAppId";
		
        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String,Object>();
        params.put("authorizerAppId", authorizerAppId);
        
        template.query(sql, params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
            	map.put(rs.getString("media_id"), rs.getTimestamp("wechat_update_time"));
                return 1;
            }
        });
        
        return map;
	}

	
	
	@Override
	public int count(String authorizerAppId) {
		SingleSqlBuilder<OrgWechatMediaNews> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        builder.count("id");
        return queryForObject(builder, Integer.class);
	}

	
	
	@Override
	public List<OrgWechatMediaNews> search(String authorizerAppId, PageDto pageDto) {
		final List<OrgWechatMediaNews> list = new ArrayList<OrgWechatMediaNews>();
		
		StringBuilder builder = new StringBuilder();
		builder.append("SELECT * FROM yunying.org_wechat_media_news WHERE authorizer_app_id=:authorizerAppId ");

		builder.append(" ORDER BY type DESC, wechat_update_time DESC");
		if( pageDto!=null ){
			builder.append(" LIMIT :start,:size");
		}
		
		
        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String,Object>();
        params.put("authorizerAppId", authorizerAppId);
        if( pageDto!=null ){
        	params.put("start", pageDto.firstNum());
        	params.put("size", pageDto.getPageSize());
        }
        
        template.query(builder.toString(), params, new RowMapper<Integer>() {
        	OrgWechatMediaNews mediaNews;
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
            	mediaNews = new OrgWechatMediaNews();
            	mediaNews.setId( rs.getInt("id") );
            	mediaNews.setAuthorizerAppId( rs.getString("authorizer_app_id") );
            	mediaNews.setMediaId( rs.getString("media_id") );
            	mediaNews.setJson( rs.getString("json") );
            	mediaNews.setWechatUpdateTime(  rs.getTimestamp("wechat_update_time") );
            	mediaNews.setUpdateTime( rs.getTimestamp("update_time") );
            	mediaNews.setCreateTime( rs.getTimestamp("create_time") );
            	list.add(mediaNews);
                return 1;
            }
        });
        
        return list;
	}

	
	
	@Override
	public void delByMediaId(String mediaId) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
		//SQL
		String sql = "DELETE FROM yunying.org_wechat_media_news WHERE media_id =:mediaId";
		
		//参数
		Map<String, Object> params = new HashMap<String,Object>();
        params.put("mediaId", mediaId);
        
        //执行
        template.update(sql, params);
	}

	@Override
	public List<OrgWechatMediaNews> getByAppIdAndType(String authorizerAppId, int type) {
		SingleSqlBuilder<OrgWechatMediaNews> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        builder.eq("type", type);
        return queryList(builder);
	}

}

