/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;


import java.util.Date;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncType;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatDataSyncLogDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatDataSyncLog;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class OrgWechatDataSyncLogDaoImpl extends JdbcTemplateDaoSupport<OrgWechatDataSyncLog> implements OrgWechatDataSyncLogDao{

	public OrgWechatDataSyncLogDaoImpl() {
		super(OrgWechatDataSyncLog.class);
	}

	@Override
	public OrgWechatDataSyncLog getByAuthorizerAppId(String appId, WechatDataSyncType type) {
		SingleSqlBuilder<OrgWechatDataSyncLog> builder = createSqlBuilder();
        builder.eq("authorizerAppId", appId);
        builder.eq("type", type);
        return uniqueResult(builder);
	}

	@Override
	public Integer countOnGoingAndUnExpired(String appId, WechatDataSyncType type) {
		SingleSqlBuilder<OrgWechatDataSyncLog> builder = createSqlBuilder();
		builder.count("id");
        builder.eq("authorizerAppId", appId);
        builder.eq("type", type);
        builder.gt("expireTime", new Date());
        builder.eq("status", WechatDataSyncStatus.ONGOING.getValue());
        return queryForObject(builder, Integer.class);
	}


}

