/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**   
 * @title       : OrgWechatCustomActivityDaoImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年1月28日 下午3:04:47 
 */
@Repository
public class OrgWechatCustomActivityDaoImpl extends JdbcTemplateDaoSupport<OrgWechatCustomActivity> implements OrgWechatCustomActivityDao{

	public OrgWechatCustomActivityDaoImpl() {
		super(OrgWechatCustomActivity.class);
	}

	@Override
	public OrgWechatCustomActivity get(int activityId, int activityType) {
		SingleSqlBuilder<OrgWechatCustomActivity> builder = createSqlBuilder();
        builder.eq("activityId", activityId);
        builder.eq("activityType", activityType);
        return uniqueResult(builder);
	}

	@Override
	public void deleteBy(int activityId, int activityType) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		String sql = "DELETE FROM yunying.org_wechat_custom_activity WHERE activity_id=:activityId AND activity_type=:activityType";
		
        Map<String, Object> params = new HashMap<String,Object>();
        params.put("activityId", activityId);
        params.put("activityType", activityType);
        template.update(sql, params);
	}

}

