/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao;

import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface FansDao extends CommonDao<Fans> {

    Fans getByOpenId(String openId);

    List<Fans> search(String authorizerAppId, String searchText, PageDto pageDto);

    Integer count(String authorizerAppId);

    Map<String,Integer> checkOpenIdExist(List<String> openIds);

    Integer countSubscribe(String authorizerAppId);

    Map<String,Fans> mapKeyOpenIdValueFans(List<String> openIds);

    //根据机构appId查询机构粉丝数,批量查询
    Map<String, Integer> fansTotaByAppIds(List<String> appIds, Date startDate, Date endDate);

    //根据机构appId查看绑定微信公众号学生数
    Map<String, Integer> getOrgWechatAuthorizerOfStudentTotal(List<String> appIds, Integer subscribe, Date startDate, Date endDate);
    
    List<Fans> listFansWhichGxsImgIsNull(String authorizerAppId, PageDto page);
    
    List<Fans> listFansWhichGxsImgIsNull(String authorizerAppId, PageDto page, Long minId, Long maxId);
    
    //批量修改粉丝关注状态为未关注
    Integer batchUpdateFansToUnSubscribe(String authorizerAppId, Collection<String> subscribeList, Date listGetTime);
    
    List<String> listOpenIds(String authorizerAppId);
    
}
