/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao;

import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface AuthorizerInfoDao extends CommonDao<AuthorizerInfo> {

    void deleteByOrgId(Integer orgId);

    void deleteByAuthorizerAppId(String appId);

    void resetOngoingStatus();

    AuthorizerInfo getByOrgId(Integer orgId);
    
    AuthorizerInfo getByOrgId(Integer orgId,boolean withMasterSearch);

    AuthorizerInfo getByUserName(String userName);

    AuthorizerInfo getByAuthorizerAppId(String appId);

    /**
     * 查询所有绑定微信公众号的机构以及它的的app_id
     */
    Map<Long, String> getExistOrgIds(List<Long> TianxiaoOrgIds);
    
    /**
     *根据orgIds 查询绑定微信公众号信息
     */
    List<AuthorizerInfo> getAuthorizerInfosByOrgIds(Collection<Long> orgIds);
}
