/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.constant;


/**   
 * @title       : WechateTemplateMsgType 
 * @description : 微信模板消息类型
 * @author      : zhenyujian
 * @date        : 2016年1月11日 下午10:11:23 
 */
public enum WechateTemplateMsgType {

	BATCH(0, "群发消息", "OPENTM206931779"),
	
	//学生
	COURSE_PLAN_TO_STU(1, "课表提醒", "OPENTM206164897"), //微信模板库 - 排课通知
	COURSE_START_TO_STU(2, "上课提醒", "OPENTM207867433"), //微信模板库 - 课程通知提醒
	COURSE_SIGNIN_TO_STU(3, "签到提醒", "OPENTM205219027"), //微信模板库 - 签到成功提醒
	COURSE_EVALUATION_TO_STU(4, "评价提醒", "OPENTM203979202"), //微信模板库 - 课后评价提醒
	TEACHER_EVALUATION_TO_STU(5, "收到老师评语", "OPENTM206165018"), //微信模板库 - 课后点评提醒
	COURSE_UPDATE_TO_STU(6, "上课调整通知", "OPENTM203313282"), //微信模板库 - 班级调课提醒
	
	//老师
	COURSE_PLAN_TO_TEACHER(7,"课表提醒", "OPENTM206051644"), //微信模板库 - 排课通知
	COURSE_START_TO_TEACHER(8, "上课提醒", "OPENTM207867433"), //微信模板库 - 课前提醒
	COURSE_EVALUATION_TO_TEACHER(9, "评价提醒", "OPENTM203979202"), //微信模板库 - 待点评提醒
	STU_EVALUATION_TO_TEACHER(10, "收到学员评语", "OPENTM203979202"), //微信模板库 - 课程评价通知

	HOMEWORK_PUBLISH_TO_STU(11,"布置作业提醒","OPENTM406772653"),
	HOMEWORK_FINISH_TO_TEACHER(12,"作业完成提醒","OPENTM406017459"),
	HOMEWORK_CORRECT_TO_STU(13,"作业批改完成提醒","OPENTM400905764"),

	EXAM_PUBLISH_TO_STU(14,"布置考试提醒","OPENTM406210378"),
	EXAM_CORRECT_TO_STU(15,"考试批改完成提醒","OPENTM406049197"),

	GRADE_OPEN_TO_STU(16,"成绩查询开启提醒","OPENTM409257668"),

	HOURS_48(100, "您有新消息", "OPENTM207379528"),
	
	;
	

	public static WechateTemplateMsgType getByVaule(int value){
		for (WechateTemplateMsgType type : WechateTemplateMsgType.values()) {
			if(type.getValue() == value){
				return type;
			}
        }
    	return null;
    }

    private int value;
    private String title;
    private String templateId;

    private WechateTemplateMsgType(int value, String title, String templateId) {
        this.value = value;
        this.title = title;
        this.templateId = templateId;
    }

    public int getValue() {
        return this.value;
    }

    public String getTitle() {
        return this.title;
    }

	public String getTemplateId() {
		return templateId;
	}
	
	public String getDemo(){
		WechateTemplateMsgType type = WechateTemplateMsgType.getByVaule(this.value);
		switch(type){
			case BATCH:
				return "{{first.DATA}} \n"
						+"通知名称：{{keyword1.DATA}} \n"
						+"通知编号：{{keyword2.DATA}} \n"
						+"通知摘要：{{keyword3.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case COURSE_PLAN_TO_STU:
				return "{{first.DATA}} \n"
						+"学员：{{keyword1.DATA}} \n"
						+"时间：{{keyword2.DATA}} \n"
						+"课程：{{keyword3.DATA}} \n"
						+"教师：{{keyword4.DATA}} \n"
						+"备注：{{keyword5.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case COURSE_START_TO_STU:
				return "{{first.DATA}} \n"
						+"上课时间：{{keyword1.DATA}} \n"
						+"老师名字：{{keyword2.DATA}} \n"
						+"课程名称：{{keyword3.DATA}} \n"
						+"上课教室：{{keyword4.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case COURSE_SIGNIN_TO_STU:
				return	"{{first.DATA}} \n"
						+"学生姓名：{{keyword1.DATA}} \n"
						+"签到时间：{{keyword2.DATA}} \n"
						+"签到课程：{{keyword3.DATA}} \n"
						+"上课老师：{{keyword4.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case COURSE_EVALUATION_TO_STU:
				return "{{first.DATA}} \n"
						+"学员姓名：{{keyword1.DATA}} \n"
						+"课程名称：{{keyword2.DATA}} \n"
						+"主讲老师：{{keyword3.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case TEACHER_EVALUATION_TO_STU:
				return "{{first.DATA}} \n"
						+"学生姓名：{{keyword1.DATA}} \n"
						+"课程名称：{{keyword2.DATA}} \n"
						+"上课老师：{{keyword3.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case COURSE_UPDATE_TO_STU:
				return "{{first.DATA}} \n"
						+"班级名：{{keyword1.DATA}} \n"
						+"原上课时间：{{keyword2.DATA}} \n"
						+"现上课时间：{{keyword3.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case COURSE_PLAN_TO_TEACHER:
				return "{{first.DATA}} \n"
						+"已排课程：{{keyword1.DATA}} \n"
						+"上课时间：{{keyword2.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case COURSE_START_TO_TEACHER:
				return "{{first.DATA}} \n"
						+"课程名称：{{keyword1.DATA}} \n"
						+"上课时间：{{keyword2.DATA}} \n"
						+"上课地点：{{keyword3.DATA}} \n"
						+"联系电话：{{keyword4.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case COURSE_EVALUATION_TO_TEACHER:
				return "{{first.DATA}} \n"
						+"课程名称：{{keyword1.DATA}} \n"
						+"上课时间：{{keyword2.DATA}} \n"
						+"上课人数：{{keyword3.DATA}} \n"
						+"未点评人数：{{keyword4.DATA}} \n"
						+"{{remark.DATA}} \n";
				
				
			case STU_EVALUATION_TO_TEACHER:
				return "{{first.DATA}} \n"
						+"课程：{{keyword1.DATA}} \n"
						+"时间：{{keyword2.DATA}} \n"
						+"{{remark.DATA}} \n";
				
		}
		
		return null;
	}

    
}