/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**   
 * @title       : WechatMediaNewsType 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年3月29日 下午11:30:14 
 */
public enum WechatMediaNewsType {

	NORMAL(0, "普通图文"),
    BUILTIN(1, "内置图文"),
    ;

    private static Map<Integer, String> map = Maps.newHashMap();

    static {
        for (WechatMediaNewsType p : values()) {
            map.put(p.getValue(), p.getNote());
        }
    }

    private int value;
    private String note;

    private WechatMediaNewsType(int value, String note) {
        this.value = value;
        this.note = note;
    }

    public int getValue() {
        return this.value;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer value) {
        return map.get(value);
    }
}