
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.upload.dao.impl;

import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.upload.dao.TxUploadRecordsDao;
import com.baijia.tianxiao.dal.upload.po.TxUploadRecords;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**
 * @title TxUploadRecordsDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2016年3月15日
 * @version 1.0
 */
@Repository
public class TxUploadRecordsDaoImpl extends JdbcTemplateDaoSupport<TxUploadRecords> implements TxUploadRecordsDao {

    @Override
    public List<TxUploadRecords> listUploadTask(Long orgId, Date startTime, Date endTime, Integer uploadType,
        Integer status) {
        SingleSqlBuilder<TxUploadRecords> builder = createSqlBuilder();
        if (orgId != null) {
            builder.eq("orgId", orgId);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }
        if (uploadType != null) {
            builder.eq("uploadType", uploadType);
        }
        if (status != null) {
            builder.eq("status", status);
        }

        return queryList(builder);

    }

}
