
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.todo.po;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.todo.constant.BacklogOperation;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

@Entity(name = "tx_backlog_operation_log")
@Table(catalog = "yunying")
@Data
public class TxBacklogOperationLog {

    @Id
    @GeneratedValue
    @Column
    private Long id;

    @Column(name = "backlog_id")
    private Long backlogId;
    
    @Column(name = "operator_org_id")
    private Long orgId;

    @Column(name = "operator_cascade_id")
    private Long cascadeId;

    @Column(name = "operation")
    private Integer operation;

    @Column(name = "create_time")
    private Date createTime;
    
    
    public static TxBacklogOperationLog buildByFinish(Long backlogId, Long orgId, Long cascadeId, int finish){
    	TxBacklogOperationLog operationLog = new TxBacklogOperationLog();
    	operationLog.setBacklogId(backlogId);
        operationLog.setOrgId(orgId);
        operationLog.setCascadeId(cascadeId.longValue());
        if (finish == Flag.FALSE.getInt()) {
        	operationLog.setOperation( BacklogOperation.UPDATE_TO_UNFINISH.getValue() );
        }else{
        	operationLog.setOperation( BacklogOperation.UPDATE_TO_FINISH.getValue() );
        }
        return operationLog;
    }
    
}
