
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.todo.po;

import com.baijia.tianxiao.dal.todo.constant.BacklogStatus;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Calendar;
import java.util.Date;

import lombok.Data;

/**
 * 待办事项
 * 
 * @title TxBacklog
 * @desc TODO
 * @author zhangbing
 * @date 2016年2月25日
 * @version 1.0
 */
@Entity(name = "tx_backlog_list")
@Table(catalog = "yunying")
@Data
public class TxBacklog implements Cloneable{

    @Id
    @GeneratedValue
    @Column
    private Long id;

    // 机构id
    @Column(name = "org_id")
    private Long orgId;

    // 子账号ID
    @Column(name = "cascade_id")
    private Integer cascadeId;

    // 咨询用户id
    @Column(name = "consult_user_id")
    private Long consultUserId;

    // 花名册用户id
    @Column(name = "student_id")
    private Long studentId;

    // 待办事项标题
    @Column(name = "content")
    private String content;

    // 来源0:手动添加,1:系统添加
    @Column(name = "is_sys")
    private int isSys;

    // 删除状态:0正常,1:删除
    @Column(name = "del_status")
    private int delStatus;

    // 提醒截止时间
    @Column(name = "end_time")
    private Date endTime;

    // 提醒时间，为null时表示不提醒
    @Column(name = "remind_time")
    private Date remindTime;

    // 创建时间
    @Column(name = "create_time")
    private Date createTime;

    // 更新时间
    @Column(name = "update_time")
    private Date updateTime;

    // 是否完成:0未完成,1=完成
    @Column(name = "finish")
    private Integer finish;
    
    //今日待办类型 见 BackLogType
    @Column(name = "type")
    private Integer type;
 
    
    public int getStatus(){
    	if(this.endTime==null){
    		return BacklogStatus.UNKNOWN.getValue();
    	}
    	
    	if(this.endTime.getTime() > getCurrentDate().getTime()){
    		return BacklogStatus.UNEXPIRED.getValue();
    	}else{
    		return BacklogStatus.EXPIRED.getValue();
    	}
    }
    
    private Date getCurrentDate() {
        Calendar today = Calendar.getInstance();
        today.set(today.get(Calendar.YEAR), today.get(Calendar.MONTH), today.get(Calendar.DATE), 0, 0, 0);
        Date date = new Date();
        date.setTime(today.getTimeInMillis() / 1000 * 1000);
        return date;
    }
    
    @Override
	public TxBacklog clone() throws CloneNotSupportedException {
		return (TxBacklog)super.clone();
	}
    
}
