/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.todo.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogParticipantDao;
import com.baijia.tianxiao.dal.todo.po.TxbacklogParticipant;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;


@Repository
public class TxBacklogParticipantDaoImpl extends JdbcTemplateDaoSupport<TxbacklogParticipant> implements TxBacklogParticipantDao {

    public TxBacklogParticipantDaoImpl() {
        super(TxbacklogParticipant.class);
    }

    
    
	@Override
	public List<TxbacklogParticipant> listByBackLogId(Long backlogId) {
		SingleSqlBuilder<TxbacklogParticipant> builder = createSqlBuilder();
        builder.eq("backlogId", backlogId);
        builder.eq("delStatus", Flag.FALSE.getInt());
        return this.queryList(builder);
	}
	
	
	
	@Override
	public List<TxbacklogParticipant> listByBackLogId(Long backlogId, Boolean delStatus) {
		SingleSqlBuilder<TxbacklogParticipant> builder = createSqlBuilder();
		builder.eq("backlogId", backlogId);
		if(delStatus!=null ){
			if(delStatus==true){
				builder.eq("delStatus", Flag.TRUE.getInt());
			}else{
				builder.eq("delStatus", Flag.FALSE.getInt());
			}
		}
        return this.queryList(builder);
	}
	
	
	
	@Override
	public List<TxbacklogParticipant> listBy(Long orgId, Long cascadeId, List<Long> backlogIds, Boolean finish) {
		SingleSqlBuilder<TxbacklogParticipant> builder = createSqlBuilder();
		builder.eq("orgId", orgId);
		builder.eq("cascadeId", cascadeId);
        builder.in("backlogId", backlogIds);
        if(finish!=null ){
			if(finish==true){
				builder.eq("finish", Flag.TRUE.getInt());
			}else{
				builder.eq("finish", Flag.FALSE.getInt());
			}
		}
        
        builder.eq("delStatus", Flag.FALSE.getInt());
        
        return this.queryList(builder);
	}

	
	
	@Override
	public List<TxbacklogParticipant> listBy(Long orgId, Long cascadeId) {
		SingleSqlBuilder<TxbacklogParticipant> builder = createSqlBuilder();
		builder.eq("orgId", orgId);
		builder.eq("cascadeId", cascadeId);
        builder.eq("delStatus", Flag.FALSE.getInt());
        
        return this.queryList(builder);
	}
	

	
	@Override
	public Map<Long, TxbacklogParticipant> keyBacklogIdValueParticipant(Long orgId, Long cascadeId) {
		Map<Long, TxbacklogParticipant> map = new HashMap<Long, TxbacklogParticipant>();
		List<TxbacklogParticipant> list = listBy(orgId, cascadeId);
		if( CollectionUtils.isNotEmpty(list) ){
			for(TxbacklogParticipant obj:list){
				map.put(obj.getBacklogId(), obj);
			}
		}
		return map;
	}
	
	
	
	@Override
	public void delByBackLogId(Long backlogId) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
		String sql = "UPDATE yunying.tx_backlog_participants SET del_status=1 WHERE backlog_id=:backlogId";
				
		Map<String, Object> params = new HashMap<String,Object>();
        params.put("backlogId", backlogId);
        
        //执行
        template.update(sql, params);
	}
	
	
	
	@Override
	public void physicallyDelByIds(List<Long> ids) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
		String sql = "DELETE FROM yunying.tx_backlog_participants WHERE id IN (:ids)";
				
		Map<String, Object> params = new HashMap<String,Object>();
        params.put("ids", ids);
        
        //执行
        template.update(sql, params);
	}

	

	@Override
	public void delBy(Long orgId, Long cascadeId, Long backlogId) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
		String sql = "UPDATE yunying.tx_backlog_participants SET del_status=1 WHERE backlog_id=:backlogId AND org_id=:orgId AND cascade_id=:cascadeId";
				
		Map<String, Object> params = new HashMap<String,Object>();
        params.put("backlogId", backlogId);
        params.put("orgId", orgId);
        params.put("cascadeId", cascadeId);
        
        //执行
        template.update(sql, params);
	}

	

	@Override
	public void delBy(Long orgId, Long cascadeId, List<Long> backlogIds) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
		String sql = "UPDATE yunying.tx_backlog_participants SET del_status=1 WHERE backlog_id IN (:backlogIds) AND org_id=:orgId AND cascade_id=:cascadeId";
				
		Map<String, Object> params = new HashMap<String,Object>();
        params.put("backlogIds", backlogIds);
        params.put("orgId", orgId);
        params.put("cascadeId", cascadeId);
        
        //执行
        template.update(sql, params);
	}
	

	
	
	@Override
	public TxbacklogParticipant getBy(Long orgId, Long cascadeId, Long backlogId) {
		SingleSqlBuilder<TxbacklogParticipant> builder = createSqlBuilder();
        builder.eq("backlogId", backlogId);
        builder.eq("orgId", orgId);
        builder.eq("cascadeId", cascadeId);
        builder.eq("delStatus", Flag.FALSE.getInt());
        return this.uniqueResult(builder);
	}

	@Override
	public void batchChangeFinish(List<Long> ids, Boolean finish) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
		String sql = "UPDATE yunying.tx_backlog_participants SET finish=:finish WHERE id IN (:ids)";
				
		Map<String, Object> params = new HashMap<String,Object>();
        params.put("ids", ids);
        
        if(finish!=null ){
			if(finish==true){
				params.put("finish", Flag.TRUE.getInt());
			}else{
				params.put("finish", Flag.FALSE.getInt());
			}
		}
        
        //执行
        template.update(sql, params);
	}



	

}