/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.todo.dao.impl;


import java.util.List;

import com.baijia.tianxiao.dal.todo.dao.TxBacklogOperationLogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklogOperationLog;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.springframework.stereotype.Repository;


@Repository
public class TxBacklogOperationLogDaoImpl extends JdbcTemplateDaoSupport<TxBacklogOperationLog> implements TxBacklogOperationLogDao {

    public TxBacklogOperationLogDaoImpl() {
        super(TxBacklogOperationLog.class);
    }

	@Override
	public List<TxBacklogOperationLog> listByBackLogId(Long backlogId) {
		SingleSqlBuilder<TxBacklogOperationLog> builder = createSqlBuilder();
        builder.eq("backlogId", backlogId);
        return this.queryList(builder);
	}

	
}