
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.todo.dao;

import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.todo.po.TxbacklogParticipant;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

public interface TxBacklogParticipantDao extends CommonDao<TxbacklogParticipant> {

   List<TxbacklogParticipant> listByBackLogId(Long backlogId);
   
   List<TxbacklogParticipant> listByBackLogId(Long backlogId, Boolean delStatus);
   
   List<TxbacklogParticipant> listBy(Long orgId, Long cascadeId, List<Long> backlogIds, Boolean finish);
   
   List<TxbacklogParticipant> listBy(Long orgId, Long cascadeId);
   
   Map<Long,TxbacklogParticipant> keyBacklogIdValueParticipant(Long orgId, Long cascadeId);
   
   void delByBackLogId(Long backlogId);
   
   void physicallyDelByIds(List<Long> ids);
   
   void delBy(Long orgId, Long cascadeId, Long backlogId);
   
   void delBy(Long orgId, Long cascadeId, List<Long> backlogIds);
   
   TxbacklogParticipant getBy(Long orgId, Long cascadeId, Long backlogId);
   
   void batchChangeFinish(List<Long> ids, Boolean finish);
   
   
   
}
