package com.baijia.tianxiao.dal.sync.po;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;


/**
 * 监控统计页面-按分钟
 * <p/>
 * Created by wengshengli on 15/12/26.
 */
@Entity(name = "tx_monitor_today_min")
@Table(catalog = "yunying")
@Data
@Slf4j
public class TxMonitorTodayMin {

    @Id
    @GeneratedValue
    private Long id;

    @Column(name = "org_number")
    private Long orgNumber;

    @Column(name = "mdate")
    private Date mdate;

    @Column(name = "page_type")
    private Integer pageType;

    @Column(name = "type_number")
    private Long typeNumber;

    @Column(name = "user_number")
    private Long userNumber;

    @Column(name = "pv")
    private Integer pv;

    @Column(name = "uuid")
    private String uuid;

    public static TxMonitorTodayMin build(String key) {

        TxMonitorTodayMin one = null;
        try {
            String[] str = key.split("#");
            if (str == null || str.length != 5) {
                return null;
            }
            one = new TxMonitorTodayMin();
            one.setOrgNumber(Long.parseLong(str[0]));
            one.setPageType(Integer.parseInt(str[1]));
            one.setUserNumber(Long.parseLong(str[2]));
            one.setUuid(str[3]);
            one.setTypeNumber(Long.valueOf(str[4]));
        } catch (Exception e) {
            log.error("数据有误,key={}", key);
            return null;
        }

        return one;
    }
}
