/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxUserSourceStatisticDayDao;
import com.baijia.tianxiao.dal.sync.po.TxUserSourceStatisticDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Date;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年10月13日
 * @desc
 */
@Repository
@Slf4j
public class TxUserSourceStatisticDayDaoImpl extends JdbcTemplateDaoSupport<TxUserSourceStatisticDay> implements TxUserSourceStatisticDayDao{
    
    public TxUserSourceStatisticDayDaoImpl(){
        super();
    }

    @Override
    public TxUserSourceStatisticDay getTxUserSourceStatisticDay(Long orgId, Long consultUserId, Integer sourceType, Date startTime, Date endTime) {
        log.info("txUserSourceStatistic orgId {}, consultUserId {}, sourceType {}", orgId, consultUserId);
        SingleSqlBuilder<TxUserSourceStatisticDay> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("consultUserId", consultUserId);
        builder.eq("sourceType", sourceType);
        
//        builder.eq("userType", userType);
        //咨询来源时间范围
        builder.ge("visitDate", startTime);
        builder.lt("visitDate", endTime);
        builder.setMaxSize(1);
        return uniqueResult(builder);
    }
    
    @Override
    public int countByOrgSource(Long orgId, int sourceType, Date startTime, Date endTime) {
        SingleSqlBuilder<TxUserSourceStatisticDay> builder = createSqlBuilder();
        builder.sum("number");
        builder.eq("orgId", orgId);
        builder.eq("sourceType", sourceType);
        builder.ge("visitDate", startTime);
        builder.lt("visitDate", endTime);
        log.info("count by org source sql= {},params:{orgId={},sourceType={},startTime={},endTime={}}", builder.toSql(), orgId, sourceType, startTime, endTime);
        Integer num = queryForObject(builder, Integer.class);
        return num == null ? 0 : num;
    }
    

}
