package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxMonitorOrgDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorOrgDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * Created by wengshengli on 15/12/29.
 */
@Repository
public class TxMonitorOrgDayDaoImpl extends JdbcTemplateDaoSupport<TxMonitorOrgDay> implements TxMonitorOrgDayDao {
    public TxMonitorOrgDayDaoImpl() {
        super(TxMonitorOrgDay.class);
    }

    @Override
    public List<TxMonitorOrgDay> lastOrgDay(Long orgNumber, Date startDate, Date endDate, String... queryProps) {
//        Date startDate = DateUtil.getDayDiff(-day);
        
        SingleSqlBuilder<TxMonitorOrgDay> builder = createSqlBuilder(queryProps);

        builder.eq("orgNumber", orgNumber);
        builder.ge("mdate", startDate);
        builder.le("mdate", endDate);
        builder.desc("mdate");

        return queryList(builder, TxMonitorOrgDay.class);
    }
}
