/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxConsultSourceStatisticMonthDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultSourceStatisticMonth;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年8月26日
 * @desc
 */
@Repository
@Slf4j
public class TxConsultSourceStatisticMonthImpl extends JdbcTemplateDaoSupport<TxConsultSourceStatisticMonth> implements TxConsultSourceStatisticMonthDao{

    @Override
    public List<TxConsultSourceStatisticMonth> getTxConsultSourceStatisticMonthBySource(Long orgId, Long consultUserId,
        Integer sourceType, Date startTime, Date endTime) {
        log.info("txConsultSourceStatisticMonth orgId {}, consultUserId {}, sourceType {}, startTime {}, endTime {}", orgId, consultUserId, sourceType, startTime, endTime);
        //对于某月， 某机构 某个人 某个咨询类型应该只产生一条记录
        SingleSqlBuilder<TxConsultSourceStatisticMonth> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("consultUserId", consultUserId);
        builder.eq("sourceType", sourceType);
        builder.ge("createTime", startTime);
        builder.lt("createTime", endTime);
        builder.asc("createTime");
//        builder.setOrder(Order.asc("createTime"));
        return queryList(builder);
    }

    @Override
    public int countByOrgSource(Long orgId, int sourceType, Date startTime, Date endTime) {
        SingleSqlBuilder<TxConsultSourceStatisticMonth> builder = createSqlBuilder();
        builder.sum("number");
        builder.eq("orgId", orgId);
        builder.eq("sourceType", sourceType);
        builder.ge("createTime", startTime);
        builder.lt("createTime", endTime);
        log.info("count by org source sql= {},params:{orgId={},sourceType={},startTime={},endTime={}}", builder.toSql(), orgId, sourceType, startTime, endTime);
        Integer num = queryForObject(builder, Integer.class);
        return num == null ? 0 : num;
    }

}
