package com.baijia.tianxiao.dal.sync.dao;

import com.baijia.tianxiao.dal.sync.po.TxMonitorCourseDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorOrgDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTodayMin;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.List;

/**
 * Created by wengshengli on 15/12/26.
 */
public interface TxMonitorTodayMinDao extends CommonDao<TxMonitorTodayMin> {

    /**
     * 判断一个小时内是否已有咨询,可发信息
     *
     * @param orgNumber
     * @param userNumber
     * @param pageTypeList
     * @param queryProps
     * @return
     */
    boolean checkByOrgUser(Long orgNumber, Long userNumber, String uuid, List<Integer> pageTypeList, String... queryProps);


    /**
     * 判断是否已存入
     *
     * @param orgNumber
     * @param pageType
     * @param userNumber
     * @param typeNumber
     * @param queryProps
     * @return
     */
    TxMonitorTodayMin getByKey(Long orgNumber, int pageType, Long userNumber, String uuid, Long typeNumber, String... queryProps);


    /**
     * 每天基础数据机构访问量
     *
     * @return
     */
    List<TxMonitorOrgDay> group2OrgDay(Long orgNumber, String... queryProps);


    /**
     * 历史页面访问量
     *
     * @param queryProps
     * @return
     */
    List<TxMonitorTypeDay> group2TypeDay(Long orgNumber, String... queryProps);

    /**
     * 课程访问量
     *
     * @param queryProps
     * @return
     */
    List<TxMonitorCourseDay> group2CourseDay(Long orgNumber, List<Integer> pageTypes, String... queryProps);

    /**
     * 获取所有的IDs
     *
     * @return
     */
    List<Long> queryForIds(String... queryProps);

    /**
     * 机构当天pv
     *
     * @param orgNumber
     * @param queryProps
     * @return
     */
    int countPvToday(long orgNumber, String... queryProps);
}
