package com.baijia.tianxiao.dal.statistic.dao.impl;

import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import java.util.*;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.stereotype.Repository;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/6/30
 * Time: 下午1:27
 * To change this template use File | Settings | File Templates.
 */
@Repository
@Slf4j
public class TxSignupRecordDayDaoImpl extends JdbcTemplateDaoSupport<TxSignupRecordDay> implements TxSignupRecordDayDao {

    public TxSignupRecordDayDaoImpl() {
        super(TxSignupRecordDay.class);
    }

    @Override
    public TxSignupRecordDay getByDayType(Long orgId, String mdate, int opType, int opTo, String... queryProps) {

        SingleSqlBuilder<TxSignupRecordDay> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("mdate", mdate);
        builder.eq("opType", opType);
        builder.eq("opTo", opTo);
        builder.setMaxSize(1);
        log.debug("getByDayType sql={},params={}", builder.toSql(), builder.collectConditionValue());
        return uniqueResult(builder);
    }

    @Override
    public List<TxSignupRecordDay> getListByMonth(int orgId, Date beginTime, Date endTime) {
        SingleSqlBuilder<TxSignupRecordDay> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.ge("mdate", beginTime);
        builder.le("mdate", endTime);
        builder.desc("mdate");
        return queryList(builder);
    }

    @Override
    public List<TxSignupRecordDay> getListByDate(Integer orgId, Date date) {
        SingleSqlBuilder<TxSignupRecordDay> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("mdate", date);
        return queryList(builder);
    }


    @Override
    public Integer maxSignupRecordId() {
        SingleSqlBuilder<TxSignupRecordDay> builder = createSqlBuilder();
        builder.max("id");
        return queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxSignupRecordDay> getTxSignupRecordListByMinId(Long minId, Date lastDate, int maxSize, String...queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<TxSignupRecordDay> builder = createSqlBuilder(queryProps);
        if (minId == null || minId == 0) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("updateTime", lastDate);
            builder.asc("updateTime");
        } else {
            builder.gt("id", minId);
            builder.asc("id");
        }

        builder.setMaxSize(maxSize);
        log.debug("getTxSignupRecordListByMinId sql={},params={}", builder.toSql(), builder.collectConditionValue());
        return queryList(builder);
    }

    @Override
    public Long getSignupPriceByDay(Long orgId, String mdate,Integer opType) {
        StringBuilder sb = new StringBuilder(
                "select sum(op_price)*100 from yunying.tx_signup_record_day where org_id = :orgId and mdate = :mdate and op_type = :opType and op_to = 1 limit 1");
        Map params = new HashedMap<String, Object>();
        params.put("orgId", orgId);
        params.put("mdate", mdate);
        params.put("opType",opType);

        return getNamedJdbcTemplate().queryForObject(sb.toString(), params, Long.class);
    }
}
