package com.baijia.tianxiao.dal.statistic.dao.impl;

import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/6/30 Time: 下午1:27 To change this template use File | Settings
 * | File Templates.
 */
@Repository
public class TxFinanceRecordDayDaoImpl extends JdbcTemplateDaoSupport<TxFinanceRecordDay>
    implements TxFinanceRecordDayDao {

    public TxFinanceRecordDayDaoImpl() {
        super(TxFinanceRecordDay.class);
    }

    @Override
    public TxFinanceRecordDay getByDayType(Long orgId, String mdate, int opType, int opTo, String...queryProps) {
        SingleSqlBuilder<TxFinanceRecordDay> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("mdate", mdate);
        builder.eq("opType", opType);
        builder.eq("opTo", opTo);
        builder.setMaxSize(1);
        return uniqueResult(builder);
    }

    @Override
    public List<TxFinanceRecordDay> list(Long orgId, Date startDate, Date endDate, String...queryProps) {
        SingleSqlBuilder<TxFinanceRecordDay> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.ge("mdate", startDate);
        builder.le("mdate", endDate);
        builder.desc("mdate");

        return queryList(builder);
    }

    @Override
    public Double getIncome(Long orgId, Date startDate, Date endDate) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgId", orgId);
        String sql =
            "select ifnull(sum(op_price),0) from yunying.tx_finance_record_day where org_id = :orgId and op_to = 1";
        if (startDate != null && endDate != null) {
            param.put("startDate", startDate);
            param.put("endDate", endDate);
            sql = sql + " and mdate <= :endDate and mdate >= :startDate";
        }
        Double money = this.getNamedJdbcTemplate().queryForObject(sql, param, Double.class);
        return money == null ? 0.00 : money.doubleValue();
    }

    @Override
    public Double getIncomes(List<Integer> orgIds, Date startDate, Date endDate) {
        SingleSqlBuilder<TxFinanceRecordDay> builder = createSqlBuilder();
        builder.sum("opPrice");
        builder.in("orgId",orgIds);
        builder.eq("opTo",1);
        if(startDate != null && endDate != null){
            builder.le("mdate",endDate);
            builder.ge("mdate",startDate);
        }
        Double money =queryForObject(builder,Double.class);
        return money == null ? 0.00 : money.doubleValue();
    }

    @Override
    public Map<Integer,Double> queryByOrgIds(List<Integer> orgIds, Date startDate, Date endDate){
        String sql =
                "select sum(op_price) as c,org_id from yunying.tx_finance_record_day where op_to=1 and mdate <= :endDate and mdate >= :startDate and org_id in (:orgIds)";
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", orgIds);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        sql += " group by org_id";
        final Map<Integer, Double> ret = new HashMap<>();
        getNamedJdbcTemplate().query(sql, param, new RowMapper<Object>() {
            @Override
            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                ret.put(rs.getInt("org_id"), rs.getDouble("c"));
                return null;
            }
        });
        return ret;
    }
}
