package com.baijia.tianxiao.dal.signup.po;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sqlbuilder.annotation.*;
import lombok.Data;

import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/6/30
 * Time: 下午6:20
 * To change this template use File | Settings | File Templates.
 */
@Entity
@Data
@Table(name = "org_signup_refund", catalog = "yunying")
public class OrgSignupRefund extends BaseDto {

    /**
     * 主键
     */
    @Id
    @GeneratedValue
    private int id;

    /**
     * 机构id
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 流水号
     */
    @Column(name = "signup_purchase_id")
    private Long signupPurchaseId;

    /**
     * 课程ID
     */
    @Column(name = "course_id")
    private Long courseId;

    /**
     * 班级ID
     */
    @Column(name = "class_id")
    private Long classId;

    /**
     * 用户id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 订单总额 单位：分
     */
    @Column(name = "refund_price")
    private Long refundPrice = 0l;

    @Column
    private  Integer chargeUnit;

    @Column
    private  Long refundLessonCount;

    /**
     * 手续费
     */
    @Column(name = "refund_fee")
    private Long refundFee = 0l;


    /**
     * 退费类型
     */
    @Column(name = "refund_type")
    private Integer refundType;
    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 退班是该订单或班级课消的次数
     */
    @Column(name = "kexiao_count")
    private Long kexiaoCount;

    /**
     * 退班是该订单或班级时的课消金额
     */
    @Column(name = "kexiao_money")
    private Long kexiaoMoney;


    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 操作人
     */
    @Column(name = "cascade_id")
    private Integer cascadeId;

}
