/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.signup.po;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;

import org.apache.http.Header;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import com.google.common.collect.Lists;

import lombok.Data;

/**
 * @author shizuwei
 * @version 1.0
 * @title OrgSignupInfo
 * @desc yunying.org_signup_info
 * @date 2015年12月3日
 */
@Entity
@Data
@Table(name = "org_signup_info", catalog = "yunying")
public class OrgSignupInfo extends BaseDto {

    /**
     * 主键
     */
    @Id
    @GeneratedValue
    private Long id;

    /**
     * 机构ID
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 机构number
     */
    @Column(name = "org_number")
    private Long orgNumber;

    /**
     * 学生姓名
     */
    @Column(name = "student_name")
    private String studentName;

    /**
     * 学生手机号码
     */
    @Column(name = "mobile")
    private String mobile;

    /**
     * 关联的用户ID
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 报名信息对应的订单ID,pay.org_singup_purchase.purchase_id
     */
    @Column(name = "signup_purchase_id")
    private Long signupPurchaseId;

    /**
     * 真正支付信息对应的订单ID,pay.org_singup_purchase.purchase_id 改价可能会变化
     */
    @Column(name = "pay_purchase_id")
    private Long payPurchaseId;

    /**
     * 经办人姓名
     */
    @Column
    private String operator;

    /**
     * 备注,最大1000个字
     */
    @Column(name = "remark")
    private String remark;

    /**
     *
     */
    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "pay_time")
    private Date payTime;

    /**
     * 是否已经拆分报名订单
     */
    @Column(name = "split_result")
    private Integer splitResult = 0;

    /**
     * 0 先刷卡后报名, 1.先报名后刷卡 2.在线报名
     */
    @Column(name = "signup_type")
    private Integer signupType = 0;

    /**
     * 0,POS刷卡, 3 在线支付, 4 现金
     */
    @Column(name = "pay_type")
    private Integer payType = 0;

    /**
     * 订单总额 单位：分
     */
    @Column(name = "total_prices")
    private Long totalPrices = 0l;

    @Column(name = "student_pay_price")
    private Long studentPayPrice;

    @Column(name = "transfer_class_money")
    private Long transferClassMoney;

    @Column(name = "transfer_refund_money")
    private Long transferRefundMoney;

    @Column(name = "transfer_refund_type")
    private Integer transferRefundType = 0;

    @Column(name = "transfer_class_order")
    private Integer transferClassOrder = 0;
    /**
     * 交易状态：0 交易中，1交易成功，2交易失败，3交易取消
     */
    @Column(name = "purchase_status")
    private Integer purchaseStatus = 0;

    /**
     * 是否删除0:未删除,1已删除
     */
    @Column(name = "is_del")
    private Integer isDel = 0;

    /**
     * 是否取消 0未取消,1已取消
     */
    @Column
    private Integer status;

    /**
     * 第三方交易流水号
     */
    @Column(name = "trade_no")
    private Long tradeNo;

    // 数据来源
    @Column(name = "source_type")
    private Integer sourceType;

    // 经办人¬
    @Column(name = "cascade_id")
    private Integer cascadeId = 0;

    // 是否发过短信
    @Column(name = "sms_send")
    private Integer smsSend;

    // 是否同步过
    @Column(name = "finance_sync")
    private Integer financeSync;

    /**
     * 报名对应课程列表
     */
    private List<OrgSignupCourse> orgSignupCourses = Lists.newArrayList();

    /**
     * 报名对应费用
     */
    private List<OrgSignupFee> orgSignupFees = Lists.newArrayList();

    /**
     * header
     */
    private Collection<Header> headers;

    private String payUrlWinxin;// 二维码
    
    public Integer getStatus(){
        return this.status;
    }

    public static final long Expiration_Time = 15 * 60 * 1000; // 转班订单过期时间 15min

    public void checkIsExpired() {
        if (this.createTime != null && this.getTransferClassOrder() == TransferClassOrder.TRANSFER_ORDER.getCode()) {
            if (System.currentTimeMillis() - this.getCreateTime().getTime() > Expiration_Time) {
                throw new BussinessException(SignupErrorCode.TRANSFER_EXPIRED, "转班订单已过期,无法进行退班退款操作");
            }
        }
    }

}
