package com.baijia.tianxiao.dal.signup.po;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/5/10
 * Time: 下午7:14
 * To change this template use File | Settings | File Templates.
 */

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import lombok.Data;

import java.util.Date;


@Entity
@Data
@Table(name = "org_signup_fee", catalog = "yunying")
public class OrgSignupFee extends BaseDto{
    /**
     * 主键
     */
    @Id
    @GeneratedValue
    private int id;

    /**
     * 机构id
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 用户id，学生id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 流水号
     */
    @Column(name = "signup_purchase_id")
    private Long signupPurchaseId;

    /**
     * 关联的费用ID
     */
    @Column(name = "fee_item_id")
    private Long feeItemId;

    /**
     * 关联的费用名称
     */
    @Column(name = "fee_item_name")
    private String feeItemName;

    /**
     * 课程原价 分
     */
    @Column(name = "origin_price")
    private Integer originPrice;

    /**
     * 折扣,90表示九折
     */
    @Column(name = "fee_item_discount")
    private Integer feeItemDiscount;

    /**
     * 优惠金额 单位：分
     */
    @Column(name = "preferential")
    private Integer preferential;

    /**
     * 课程购买数量
     */
    @Column
    private Integer count;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 支付价格 payPrice = originPrice * courseDiscount - preferential；
     */
    @Column(name = "pay_price")
    private Long payPrice;
}

