package com.baijia.tianxiao.dal.signup.po;

import com.baijia.tianxiao.sqlbuilder.annotation.*;
import lombok.Data;

import java.util.Date;

/**
 * Created by liuxp on 16/12/2.
 */
@Entity
@Data
@Table(name = "tx_signup_course_lesson", catalog = "yunying")
public class OrgSignupCourseLesson {
    @Id
    @GeneratedValue
    private long id;
    @Column(name = "org_id")
    private Long orgId;
    @Column
    private Long signupCourseId;
    @Column
    private Long userId;
    @Column
    private Long classId;
    @Column
    private Long courseId;
    @Column
    private Long lessonId;
    @Column
    private Integer lessonType;
    @Column
    private Integer chargeUnit;
    @Column
    private Integer kexiaoStatus;//0:未课消,1:已课消
    @Column
    private Integer lessonDuration;//课时长,分钟为单位
    @Column
    private Long amount;//金额，单位分
    @Column
    private Date createTime;

    private int lessonCount;

    public static OrgSignupCourseLesson create(OrgSignupCourse signupCourse){
        OrgSignupCourseLesson courseLesson = new OrgSignupCourseLesson();
        courseLesson.setOrgId(signupCourse.getOrgId());
        courseLesson.setSignupCourseId(signupCourse.getId());
        courseLesson.setUserId(signupCourse.getUserId());
        courseLesson.setClassId(signupCourse.getClassId());
        courseLesson.setCourseId(signupCourse.getOrgCourseId());
        courseLesson.setChargeUnit(signupCourse.getChargeUnit());
        courseLesson.setLessonCount(0);
        courseLesson.setLessonDuration(0);
        courseLesson.setAmount(0L);
        return courseLesson;
    }
}
