
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.signup.po;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import lombok.Data;

import java.util.Date;


/**
 * @author shizuwei
 * @version 1.0
 * @title OrgSignupCourse
 * @desc yunying.org_signup_course
 * @date 2015年12月3日
 */
@Entity
@Data
@Table(name = "org_signup_course", catalog = "yunying")
public class OrgSignupCourse extends BaseDto {
    /**
     * 主键
     */
    @Id
    @GeneratedValue
    private Long id;

    /**
     * 机构id
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 对应org_students表内userd_id字段
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 流水号
     */
    @Column(name = "signup_purchase_id")
    private Long signupPurchaseId;

    /**
     * 关联的课程
     */
    @Column(name = "org_course_id")
    private Long orgCourseId;

    /**
     * 关联的班级ID
     */
    @Column(name = "class_id")
    private Long classId;

    /**
     * 关联的课程number
     */
    @Column(name = "org_course_number")
    private Long orgCourseNumber;

    /**
     * 课程原价 分
     */
    @Column(name = "origin_price")
    private Integer originPrice;

    /**
     * 折扣,90表示九折
     */
    @Column(name = "course_discount")
    private Integer courseDiscount;

    /**
     * 优惠金额 单位：分
     */
    @Column(name = "preferential")
    private Integer preferential;

    /**
     * 课程购买数量
     */
    @Column
    private Integer count;

    /**
     * 合同课次，按期用户可填写，按次按小时和购买数量相同
     */
    @Column
    private Integer lessonCount;

    /**
     * 收费单位
     */
    @Column
    private Integer chargeUnit;

    /**
     * 课消补充信息时间
     */
    @Column(name = "kexiao_time")
    private Date kexiaoTime;
    /**
     * 课消补充信息操作人
     */
    @Column(name = "kexiao_cascade_id")
    private Integer kexiaoCascadeId;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 创建时间
     */
    @Column(name = "update_time")
    private Date updateTime;

    /**
     * 支付价格 payPrice = originPrice * courseDiscount - preferential；
     */
    @Column(name = "pay_price")
    private Long payPrice = 0l;

    @Column(name = "student_pay_price")
    private Long studentPayPrice = 0l;

    @Column(name = "transfer_purchase_money")
    private Long transferPurchaseMoney = 0l;

    @Column
    private Integer status;

    @Column
    private Integer isDel;

    @Column(name = "sync_lesson_count")
    private Integer syncLessonCount;

    //数据传输
    private Integer sqlCount;
    private Integer supplement;
    private Long lessonPrice;//(payPrice+studentPayPrice)*lessonCount

    public Long getTotalPayPrice() {
        return this.payPrice + this.studentPayPrice + this.getTransferPurchaseMoney();
    }

}

    