package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.SignupRefundStorageDao;
import com.baijia.tianxiao.dal.signup.po.TxSignupRefundStorage;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Author: hanlaijin Date: 16/12/5 下午5:06
 */
@Repository
@Slf4j
public class SignupRefundStorageDaoImpl extends JdbcTemplateDaoSupport<TxSignupRefundStorage>
        implements SignupRefundStorageDao {

    public SignupRefundStorageDaoImpl() {
        super(TxSignupRefundStorage.class);
    }

    @Override
    public List<TxSignupRefundStorage> getTxSignupRefundStorage(Long orgId, Long signupPurchaseId, Long courseId, Long userId, Long storageId) {
        SingleSqlBuilder<TxSignupRefundStorage> sqlBuilder = createSqlBuilder();

        if (signupPurchaseId != null) {
            sqlBuilder.eq("signupPurchaseId", signupPurchaseId.longValue());
        }
        sqlBuilder.eq("userId", userId == null ? 0 : userId.longValue());
        sqlBuilder.eq("courseId", courseId);
        sqlBuilder.eq("orgId", orgId);
        if (storageId != null) {
            sqlBuilder.eq("storageId", storageId);
        }
        sqlBuilder.desc("id");
        return this.queryList(sqlBuilder);
    }
}
