package com.baijia.tianxiao.dal.signup.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/6/30 Time: 下午6:25 To change this template use File | Settings
 * | File Templates.
 */
@Slf4j
@Repository
public class OrgSignupRefundDaoImpl extends JdbcTemplateDaoSupport<OrgSignupRefund> implements OrgSignupRefundDao {

    OrgSignupRefundDaoImpl() {
        super(OrgSignupRefund.class);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundListByMinId(Long minId, Date lastDate, int maxSize,
        String...queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder(queryProps);
        if (minId == null || minId == 0) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("createTime", lastDate);
            builder.asc("createTime");
        } else {
            builder.gt("id", minId);
            builder.asc("id");
        }
        builder.setMaxSize(maxSize);
        return queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundListByPurchaseId(Long orgId, Long purchaseId, Long courseId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("signupPurchaseId", purchaseId);
        builder.eq("courseId", courseId);
        return queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> getOrgSignupRefundByStudent(Long orgId, Long purchaseId, Long userId, Long courseId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (purchaseId != null && purchaseId != 0) {
            builder.eq("signupPurchaseId", purchaseId);
        }
        // 有订单号就不需要userId查询
        if (userId != null && userId != 0 && (purchaseId == null || purchaseId == 0)) {
            builder.eq("userId", userId);
        }
        builder.eq("courseId", courseId);
        builder.desc("id");
        log.debug("getOrgSignupRefundByStudent sql={},params={}", builder.toSql(), builder.collectConditionValue());
        return queryList(builder);
    }

    @Override
    public int getRefundTime(Long orgId, Long signupPurchaseId, Long courseId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("orgId", orgId);
        builder.eq("signupPurchaseId", signupPurchaseId);
        builder.eq("courseId", courseId);
        return queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgSignupRefund> getByPurcahseIds(Set<Long> purchaseIds) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.in("signupPurchaseId", purchaseIds);
        return queryList(builder);
    }

    @Override
    public List<Integer> listIdsByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime,
        Date endTime) {
        final List<Integer> result = new ArrayList<Integer>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.org_signup_refund WHERE class_id>0");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (userId != null) {
            builder.append(" AND user_id=:userId");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<:endTime");
        }

        builder.append(" ORDER BY create_time DESC");

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classIds", classIds);
        params.put("userId", userId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getInt("id"));
                return 1;
            }
        });

        return result;
    }

    @Override
    public List<OrgSignupRefund> listByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime,
        Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.gt("classId", 0);
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (userId != null) {
            builder.eq("userId", userId);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.lt("createTime", endTime);
        }

        return queryList(builder);
    }

    @Override
    public List<Integer> listIdsByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime,
        Date endTime) {
        final List<Integer> result = new ArrayList<Integer>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.org_signup_refund WHERE class_id>0");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (classId != null) {
            builder.append(" AND class_id=:classId");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<:endTime");
        }

        builder.append(" ORDER BY create_time DESC");

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classId", classId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getInt("id"));
                return 1;
            }
        });

        return result;
    }

    @Override
    public List<OrgSignupRefund> listByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime,
        Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.gt("classId", 0);
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        if (classId != null) {
            builder.eq("classId", classId);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        return queryList(builder);
    }

    @Override
    public List<Integer> listIdsByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        final List<Integer> result = new ArrayList<Integer>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.org_signup_refund WHERE class_id>0");

        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<:endTime");
        }

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getInt("id"));
                return 1;
            }
        });

        return result;
    }

    @Override
    public List<OrgSignupRefund> listByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();

        builder.gt("classId", 0);

        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        return queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> listByOrgId(Long orgId, Collection<Long> classIds, Collection<Long> userIds,
        Date startTime, Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.eq("orgId", orgId);

        builder.gt("classId", 0);
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (userIds != null) {
            builder.in("userId", userIds);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        return queryList(builder);
    }

    @Override
    public Long sumRefundFeeByOrgId(Long orgId, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.sum("refundFee");

        builder.gt("classId", 0);
        builder.eq("orgId", orgId);

        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        Long result = queryForObject(builder, Long.class);
        return result != null ? result : 0;
    }

    @Override
    public Long sumRefundFeeByClassId(Long orgId, Long classId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.sum("refundFee");

        builder.gt("classId", 0);
        builder.eq("orgId", orgId);
        builder.eq("classId", classId);

        Long result = queryForObject(builder, Long.class);
        return result != null ? result : 0;
    }

    @Override
    public Long sumRefundFeeByUserId(Long orgId, Long userId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.sum("refundFee");

        builder.gt("classId", 0);
        builder.eq("orgId", orgId);
        builder.eq("userId", userId);

        Long result = queryForObject(builder, Long.class);
        return result != null ? result : 0;
    }

    @Override
    public Long sumRefundFeeByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.sum("refundFee");

        builder.gt("classId", 0);
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        Long result = queryForObject(builder, Long.class);
        return result != null ? result : 0;
    }

    @Override
    public Long sumRefundFeeByUserIds(Long orgId, Collection<Long> userIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.sum("refundFee");

        builder.gt("classId", 0);

        builder.eq("orgId", orgId);

        if (userIds != null) {
            builder.in("userId", userIds);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        Long result = queryForObject(builder, Long.class);
        return result != null ? result : 0;
    }

    @Override
    public Long sumRefundFeeByOrgIds(Collection<Long> orgIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.sum("refundFee");

        builder.gt("classId", 0);
        builder.in("orgId", orgIds);

        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        Long result = queryForObject(builder, Long.class);
        return result != null ? result : 0;
    }

    @Override
    public Map<Long, Long> mapRefundFeeByOrgIds(Collection<Long> orgIds, Date startTime, Date endTime) {
        final Map<Long, Long> result = new HashMap<Long, Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT org_id, sum(refund_fee) AS refund_fee FROM yunying.org_signup_refund WHERE class_id>0");
        if (CollectionUtils.isNotEmpty(orgIds)) {
            builder.append(" AND org_id IN (:orgIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }
        builder.append(" GROUP BY org_id");

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgIds", orgIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("org_id"), rs.getLong("refund_fee"));
                return 1;
            }
        });

        return result;
    }

    public Map<Long, Long> mapRefundFeeByClassIds(Collection<Long> classIds, Date startTime, Date endTime) {
        final Map<Long, Long> result = new HashMap<Long, Long>();

        StringBuilder builder = new StringBuilder();
        builder
            .append("SELECT class_id, sum(refund_fee) AS refund_fee FROM yunying.org_signup_refund WHERE class_id>0");
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }
        builder.append(" GROUP BY class_id");

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("class_id"), rs.getLong("refund_fee"));
                return 1;
            }
        });

        return result;
    }

    public Map<Long, Long> mapRefundFeeByUserIds(Long orgId, Collection<Long> userIds, Date startTime, Date endTime) {
        final Map<Long, Long> result = new HashMap<Long, Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT user_id, sum(refund_fee) AS refund_fee FROM yunying.org_signup_refund WHERE class_id>0");
        builder.append(" AND org_id=:orgId");
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }
        builder.append(" GROUP BY user_id");

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.put(rs.getLong("user_id"), rs.getLong("refund_fee"));
                return 1;
            }
        });

        return result;
    }

    private static final String syncUpdateSql =
        "update yunying.org_signup_refund set class_id = :classId where class_id = -1 and org_id = :orgId and user_id =:userId and course_id = :courseId";

    @Override
    public void syncRealCourseId(Collection<String> syncDatas) {
        if (GenericsUtils.isNullOrEmpty(syncDatas)) {
            return;
        }
        Map<String, Object> paramMap = Maps.newHashMap();
        for (String syncDataStr : syncDatas) {
            log.info(" syncDataStr is :{} ", syncDataStr);
            List<Long> stringToNumber = GenericsUtils.stringToNumberList(syncDataStr, "_", Long.class);
            Long userId = stringToNumber.get(0);
            Long courseId = stringToNumber.get(1);
            Long orgId = stringToNumber.get(2);
            Long classId = stringToNumber.get(3);
            paramMap.put("userId", userId);
            paramMap.put("courseId", courseId);
            paramMap.put("orgId", orgId);
            paramMap.put("classId", classId);
            log.info("update org_signup_refund with sql:{} and paramMap: {}", syncUpdateSql, paramMap);
            try {
                this.getNamedJdbcTemplate().update(syncUpdateSql, paramMap);
            } catch (Exception e) {
                log.info("can not sync :{} cause by :{} ", syncDataStr, e);
            }
        }
    }

    @Override
    public List<Long> pageDistinctClassId(Long orgId, Collection<Long> classIds, Date startTime, Date endTime,
        PageDto pageDto) {
        final List<Long> result = new ArrayList<Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT DISTINCT(class_id) FROM yunying.org_signup_refund WHERE class_id>0");
        if (orgId != null) {
            builder.append(" AND org_id=:orgId");
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.append(" AND class_id IN (:classIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }

        if (pageDto != null) {
            builder.append(" LIMIT :limitFrom,:limitTo");
        }

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("classIds", classIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (pageDto != null) {
            params.put("limitFrom", pageDto.firstNum());
            params.put("limitTo", pageDto.getPageSize());
        }

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("class_id"));
                return 1;
            }
        });

        return result;
    }

    @Override
    public List<Long> pageDistinctUserId(Long orgId, Collection<Long> userIds, Date startTime, Date endTime,
        PageDto pageDto) {
        final List<Long> result = new ArrayList<Long>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT DISTINCT(user_id) FROM yunying.org_signup_refund WHERE class_id>0");

        if (orgId != null) {
            builder.append(" AND org_id=:orgId");
        }

        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.append(" AND user_id IN (:userIds)");
        }
        if (startTime != null) {
            builder.append(" AND create_time>=:startTime");
        }
        if (endTime != null) {
            builder.append(" AND create_time<=:endTime");
        }

        if (pageDto != null) {
            builder.append(" LIMIT :limitFrom,:limitTo");
        }

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("userIds", userIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (pageDto != null) {
            params.put("limitFrom", pageDto.firstNum());
            params.put("limitTo", pageDto.getPageSize());
        }

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("user_id"));
                return 1;
            }
        });

        return result;
    }

    @Override
    public List<OrgSignupRefund> pageByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime,
        PageDto pageDto) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.gt("classId", 0);
        if (orgId != null) {
            builder.eq("orgId", orgId);
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }

        return queryList(builder);
    }

    @Override
    public Integer countByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.count("id");
        builder.gt("classId", 0);
        if (orgId != null) {
            builder.eq("orgId", orgId);
        }
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        Integer result = queryForObject(builder, Integer.class);
        return result != null ? result : 0;
    }

    @Override
    public Map<String, Long> sumRefundMoney(Long orgId, Collection<Long> courseIds, Collection<Long> userIds) {

        if (GenericsUtils.isNullOrEmpty(userIds) || GenericsUtils.isNullOrEmpty(courseIds)) {
            return Maps.newHashMap();
        }

        String sql = // + refund_fee
            "select user_id as userId , course_id as courseId , sum(refund_price + refund_fee) as refundMoney from yunying.org_signup_refund where org_id = :orgId and  user_id in(:userIds) and course_id in(:courseIds) group by user_id,course_id";

        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("orgId", orgId);
        paramMap.put("userIds", userIds);
        paramMap.put("courseIds", courseIds);
        final Map<String, Long> refundMoneyMap = Maps.newHashMap();
        this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<Integer>() {
            @Override
            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    long refundMoney = rs.getLong("refundMoney");
                    long userId = rs.getLong("userId");
                    long courseId = rs.getLong("courseId");
                    refundMoneyMap.put(String.format("%s_%s", userId, courseId), refundMoney);
                }
                return null;
            }
        });

        return refundMoneyMap;
    }

    @Override
    public List<OrgSignupRefund> listOrderByCreateTime(List<Integer> ids) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.in("id", ids);
        builder.desc("create_time");
        return queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> listOrderByUserIds(Long orgId, Collection<Long> userIds) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.in("userId",userIds);
        builder.eq("orgId", orgId);
        return queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> listOrderByUserIdAndCourseId(Long orgId, Long userId, Long courseId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.eq("userId",userId);
        builder.eq("courseId",courseId);
        builder.eq("orgId", orgId);
        return queryList(builder);
    }

    @Override
    public List<OrgSignupRefund> listOrderByUserIdsAndCourseId(Long orgId, Collection<Long> userIds, Long courseId) {
        SingleSqlBuilder<OrgSignupRefund> builder = createSqlBuilder();
        builder.in("userId",userIds);
        builder.eq("courseId",courseId);
        builder.eq("orgId", orgId);
        return queryList(builder);
    }
}
