package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.wx.constant.WxOrderStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.exception.NonUniqueResultException;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.BatchQueryTemplate;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

@Repository
@Slf4j
public class OrgSignupInfoDaoImpl extends JdbcTemplateDaoSupport<OrgSignupInfo> implements OrgSignupInfoDao {

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    public OrgSignupInfoDaoImpl() {
        super(OrgSignupInfo.class);
    }

    @Override
    public int countByOrgIdUserIdStatus(@NonNull Long orgId, @NonNull Long userId, Integer status){
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("orgId", orgId);
        builder.eq("userId", userId);
        builder.eq("isDel", DeleteStatus.NORMAL.getValue());
        if (status != null) {
            if (status.intValue() == WxOrderStatus.FINISH.getCode()) {
                builder.eq("purchaseStatus", PayStatus.SUCESS.getCode());
            }
            else if (status.intValue() == WxOrderStatus.CANCEL.getCode()) {
                builder.eq("status", DeleteStatus.DELETED.getValue());
            } else if (status.intValue() == WxOrderStatus.NOT_PAY.getCode()){
                builder.eq("purchaseStatus", PayStatus.PROCESSING.getCode());
                builder.ne("status", DeleteStatus.DELETED.getValue());
            }
        }
        return queryForObject(builder, Integer.class);
    }


    @Override
    public int countByOrgId(Long orgId) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("orgId", orgId);
        builder.eq("isDel", DataStatus.NORMAL.getValue());
        return queryForObject(builder, Integer.class);
    }

    @Override
    public int countByOrgId(Long orgId, int monthDiff) {

        StringBuilder sb = new StringBuilder("select count(1) from yunying.org_signup_info");
        sb.append(" where org_id = :orgId and is_del =:isDel");
        sb.append(
            " and  date_format(create_time,'%Y-%m')=date_format(DATE_SUB(curdate(), INTERVAL :monthDiff MONTH),'%Y-%m')");

        Map<String, Object> params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("isDel", DataStatus.NORMAL.getValue());
        params.put("monthDiff", monthDiff);
        return getNamedJdbcTemplate().queryForObject(sb.toString(), params, Integer.class);
    }

    @Override
    public int countByTime(@NonNull Long orgId, Date startTime, Date endTime) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.count("id");

        builder.eq("orgId", orgId);

        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        return queryForObject(builder, Integer.class);

    }

    @Override
    public int countByPurchaseStatus(@NonNull Long orgId, @NonNull Collection<Integer> purchaseStatus,
        @NonNull Collection<Integer> splitResults, Integer cascadeId) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.count("id");
        builder.eq("orgId", orgId);
        builder.in("purchaseStatus", purchaseStatus);
        builder.in("splitResult", splitResults);
        builder.eq("isDel", 0);
        builder.eq("status", 0);
        log.info("countByPurchaseStatus==sql={}params={}", builder.toSql(), builder.collectConditionValue());
        if (cascadeId != null) {
            builder.eq("cascadeId", cascadeId);
        }
        return queryForObject(builder, Integer.class);
    }

    @Override
    public Long sumByPurchaseStatus(@NonNull Long orgId, @NonNull Collection<Integer> purchaseStatus,
        @NonNull Collection<Integer> splitResults, Integer cascadeId, boolean notCash) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.sum("totalPrices");
        builder.eq("orgId", orgId);
        builder.in("purchaseStatus", purchaseStatus);
        builder.in("splitResult", splitResults);
        builder.eq("isDel", 0);
        builder.eq("status", 0);
        if (cascadeId != null) {
            builder.eq("cascadeId", cascadeId);
        }
        if (notCash) {
            builder.ne("payType", 4);// 不包括现金
        }
        Long sum = queryForObject(builder, Long.class);

        log.debug("sumByPurchaseStatus=sql={},params={},{}", builder.toSql(), builder.collectConditionValue(), sum);
        return sum == null ? 0 : sum;
    }

    @Override
    public List<Long> searchPurchaseIdByStudentInfo(@NonNull Long orgId, @NonNull String key, Date startTime,
        Date endTime) {
        if (StringUtils.isBlank(key)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.select("signupPurchaseId");

        builder.eq("orgId", orgId);
        builder.or(Expressions.like("studentName", key, MatchMode.ANYWHERE),
            Expressions.like("mobile", key, MatchMode.ANYWHERE));

        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        return queryForList(builder, Long.class);

    }

    @Override
    public List<OrgSignupInfo> getOrgSignupInfo(List<Integer> method, List<Integer> source, Long orgId,
                                                Collection<Long> purchaseIds, Collection<Integer> purchaseStatus, Collection<Integer> splitResults,
                                                Collection<Integer> payTypes, String key, Date startTime, Date endTime, Integer cascadeId, Integer cancelStatus, Integer transferClassOrder, PageDto page,
                                                String... queryPropes) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.select(queryPropes);
        builder.eq("orgId", orgId);
        if (StringUtils.isNotBlank(key)) {
            Expression exp = Expressions.or(Expressions.like("studentName", key, MatchMode.ANYWHERE),
                Expressions.like("mobile", key, MatchMode.ANYWHERE));
            exp = Expressions.or(exp, Expressions.like("signupPurchaseId", key, MatchMode.ANYWHERE));
            exp = Expressions.or(exp, Expressions.like("tradeNo", key, MatchMode.ANYWHERE));

            if (CollectionUtils.isNotEmpty(purchaseIds)) {
                exp = Expressions.or(exp, Expressions.in("signupPurchaseId", purchaseIds));
            }
            builder.add(exp);

        }


        if (startTime != null) {
            builder.ge("payTime", startTime);
        }
        if (endTime != null) {
            builder.le("payTime", endTime);
        }
        // 子账号及主管以下显示自己的报名
        if (cascadeId != null) {
            builder.eq("cascadeId", cascadeId);
        }
        if (method != null && method.size() != 0) {
            builder.in("payType", method);
        } else {
            builder.in("payType", payTypes);
        }
        if (source != null && source.size() != 0) {
            builder.in("sourceType", source);
        }

        if (cancelStatus != null) {
            builder.eq("status", cancelStatus);
        }

        if (CollectionUtils.isNotEmpty(splitResults)) {
            builder.in("splitResult", splitResults);
        }

        if (CollectionUtils.isNotEmpty(purchaseStatus)) {
            builder.in("purchaseStatus", purchaseStatus);
        }
        if (transferClassOrder != null && transferClassOrder != TransferClassOrder.ALL.getCode()) {
            builder.eq("transferClassOrder",transferClassOrder);
        }

        builder.eq("isDel", DataStatus.NORMAL.getValue());
        builder.desc("createTime");
        builder.setPage(page);
        log.info("getOrgSignupInfo sql={},params={}", builder.toSql(), builder.collectConditionValue());
        return queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> searchByPayPurchaseIds(@NonNull Collection<Long> purchaseIds,
        final String...queryProps) {
        if (purchaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        BatchQueryTemplate<Long, List<OrgSignupInfo>> queryTemplate = new ListBatchQueryTemplate<>();
        return queryTemplate.batchQuery(purchaseIds, new BatchQueryCallback<Long, List<OrgSignupInfo>>() {
            @Override
            public List<OrgSignupInfo> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
                builder.select(queryProps);
                builder.in("payPurchaseId", querySet);
                return queryList(builder);
            }
        });
    }

    @Override
    public List<OrgSignupInfo> searchByPurchaseIds(@NonNull Collection<Long> purchaseIds, final String...queryProps) {
        if (purchaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        BatchQueryTemplate<Long, List<OrgSignupInfo>> queryTemplate = new ListBatchQueryTemplate<>();
        return queryTemplate.batchQuery(purchaseIds, new BatchQueryCallback<Long, List<OrgSignupInfo>>() {
            @Override
            public List<OrgSignupInfo> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
                builder.select(queryProps);
                builder.in("signupPurchaseId", querySet);
                return queryList(builder);
            }
        });
    }

    @Override
    public OrgSignupInfo searchByPurchaseId(@NonNull Long purchaseId, boolean isLock, String...queryProps) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.select(queryProps);
        builder.desc("createTime");
        builder.eq("signupPurchaseId", purchaseId);
        builder.setMaxSize(1);

        List<OrgSignupInfo> results = getNamedJdbcTemplate().query(builder.toSql(isLock),
            builder.collectConditionValue(), new BeanPropertyRowMapper<OrgSignupInfo>(OrgSignupInfo.class));
        if (CollectionUtils.isEmpty(results)) {
            return null;
        } else if (results.size() == 1) {
            return results.get(0);
        } else {
            throw new NonUniqueResultException(builder.toSql());
        }
    }

    @Override
    public OrgSignupInfo searchByPayPurchaseId(@NonNull Long payPurchaseId, boolean isLock, String...queryProps) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.select(queryProps);
        builder.desc("createTime");
        builder.eq("payPurchaseId", payPurchaseId);
        builder.setMaxSize(1);

        List<OrgSignupInfo> results = getNamedJdbcTemplate().query(builder.toSql(isLock),
            builder.collectConditionValue(), new BeanPropertyRowMapper<OrgSignupInfo>(OrgSignupInfo.class));
        if (CollectionUtils.isEmpty(results)) {
            return null;
        } else if (results.size() == 1) {
            return results.get(0);
        } else {
            throw new NonUniqueResultException(builder.toSql());
        }
    }

    @Override
    public OrgSignupInfo searchByPurchaseId(@NonNull Long purchaseId, String...queryProps) {
        return searchByPurchaseId(purchaseId, false, queryProps);
    }

    @Override
    public void saveOrUpdateSignupInfo(@NonNull OrgSignupInfo signupInfo) {
        if (signupInfo.getId() != null && signupInfo.getId() > 0) {
            update(signupInfo);
        } else {
            save(signupInfo);
        }
    }

    @Override
    public List<OrgSignupInfo> searchHistoryPurchases(Integer purchaseStatus, Date createTime, Integer maxSize) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.eq("purchaseStatus", purchaseStatus);
        builder.gt("create_time", createTime);
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        builder.asc("create_time");
        return queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> getPurchases(Long userId, Long orgNumber, Integer payType, Integer purchaseStutus,
        String...queryProps) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder(queryProps);
        builder.eq("orgNumber", orgNumber);
        builder.eq("userId", userId);
        if (payType != null) {
            builder.eq("payType", payType);
        }
        builder.eq("purchaseStatus", purchaseStutus);
        builder.desc("createTime");
        return queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> getPurchases(Date updateTime, Integer purchaseStatus, PageDto page,
        String...queryProps) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder(queryProps);
        builder.gt("updateTime", updateTime);
        builder.eq("purchaseStatus", purchaseStatus);
        builder.setPage(page);
        builder.desc("updateTime");
        return queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> getNeedCannelPurchases(TransferClassOrder transClassOrder, Date updateTime,
        String...queryProps) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder(queryProps);
        if (transClassOrder == TransferClassOrder.TRANSFER_ORDER) {
            builder.eq("transferClassOrder", TransferClassOrder.TRANSFER_ORDER.getCode());
        }
        builder.ne("purchaseStatus", 1);// 不等于支付成功的
        builder.ne("status", 1);// 不等于已经取消的
        builder.ne("isDel", DataStatus.DELETE.getValue());// 不等于删除的
        builder.le("updateTime", updateTime);
        builder.setMaxSize(100);
        return queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> getOrgSignupListByMinId(Long minId, Date lastDate, int maxSize, String...queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder(queryProps);
        if (minId == null || minId == 0) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("updateTime", lastDate);
            builder.asc("updateTime");
        } else {
            builder.gt("id", minId);
            builder.asc("id");
        }

        builder.setMaxSize(maxSize);
        log.debug("getOrgSignupListByMinId sql={},params={}", builder.toSql(), builder.collectConditionValue());
        return queryList(builder);
    }

    @Override
    public int countByTime(List<Long> orgId, Date startTime, Date endTime) {

        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.count("id");

        builder.in("orgId", orgId);
        builder.eq("purchaseStatus", PayStatus.SUCESS.getCode());
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }

        return queryForObject(builder, Integer.class);

    }

    @Override
    public List<OrgSignupInfo> getPurchases(Date startTime, Date endTime, List<Long> orgIds, PageDto page) {

        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.in("orgId", orgIds);
        builder.ge("createTime", startTime);
        builder.le("createTime", endTime);
        builder.eq("purchaseStatus", PayStatus.SUCESS.getCode());
        builder.setPage(page);
        builder.desc("createTime");
        return queryList(builder);
    }

    @Override
    public OrgSignupInfo getOrgSignupInfoByUserId(Long orgId, Long userId) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("userId", userId);
        return null;
    }

    @Override
    public List<OrgSignupInfo> getOrgSignupListByUpdate(Long minId, Date lastDate, int maxSize, String...queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder(queryProps);
        builder.gt("updateTime", lastDate);
        builder.asc("updateTime");
        builder.setMaxSize(maxSize);
        return queryList(builder);
    }
    /*
     * @Override public List<OrgSignupInfo> getList(Integer orgId,SignupSearchRequest signupSearchRequest) {
     * SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder(); builder.eq("orgId", orgId);
     * builder.eq("is_del",DataStatus.NORMAL.getValue()); if (StringUtils.isNotBlank(signupSearchRequest.getKeyword()))
     * { String key = signupSearchRequest.getKeyword(); Expression exp =
     * Expressions.or(Expressions.like("signup_purchase_id", key, MatchMode.ANYWHERE), Expressions.like("mobile", key,
     * MatchMode.ANYWHERE)); exp = Expressions.or(exp, Expressions.like("student_name", key, MatchMode.ANYWHERE));
     * //课程名称exp = Expressions.or(exp, Expressions.like("tradeNo", key, MatchMode.ANYWHERE)); builder.add(exp); } if
     * (signupSearchRequest.getBeginDate() != null) { builder.ge("createTime", signupSearchRequest.getBeginDate()); } if
     * (signupSearchRequest.getEndDate() != null) { builder.le("createTime", signupSearchRequest.getEndDate()); }
     * if(signupSearchRequest.getMethod()!=null){ int method = signupSearchRequest.getMethod(); builder.eq("pay_type",
     * method); } // if(signupSearchRequest.getSource()!=null){ // int source = signupSearchRequest.getSource(); //
     * builder.eq("", source); // } if(signupSearchRequest.getStatus()!=null){ int status =
     * signupSearchRequest.getStatus(); builder.eq("signup_type", status); } return queryForList(builder,
     * OrgSignupInfo.class); }
     */

    @Override
    public OrgSignupInfo getByPurchaseId(Long orgId, Long signupPurchaseId) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.eq("is_del", 0);
        builder.eq("org_id", orgId);
        builder.eq("signup_purchase_id", signupPurchaseId);
        log.debug("＝＝＝＝＝＝＝＝＝getOrgSignupInfo sql={},params={}", builder.toSql(), builder.collectConditionValue());
        return uniqueResult(builder);
    }

    @Override
    public Map<Integer, Integer> countSubOrgByTime(List<Integer> orgId, Date startTime, Date endTime) {
        final Map<Integer, Integer> data = Maps.newHashMap();
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.count("id", "num");
        builder.in("orgId", orgId);
        builder.group("orgId");
        builder.eq("purchaseStatus", PayStatus.SUCESS.getCode());
        if (startTime != null) {
            builder.ge("createTime", startTime);
        }
        if (endTime != null) {
            builder.le("createTime", endTime);
        }
        getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                data.put(rs.getInt("orgId"), rs.getInt("num"));
            }
        });
        return data;
    }

    @Override
    public List<OrgSignupInfo> listByStatus(Long orgId, Collection<Integer> purchaseStatus,
        Collection<Integer> splitResults, Integer cascadeId, boolean notCash, PageDto page, String...queryPropes) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder(queryPropes);
        builder.select(queryPropes);
        builder.eq("orgId", orgId);

        // 子账号及主管以下显示自己的报名
        if (cascadeId != null) {
            builder.eq("cascadeId", cascadeId);
        }

        if (notCash) {
            builder.ne("payType", 4);// 不包括现金
        }

        builder.eq("isDel", 0);
        builder.in("purchaseStatus", purchaseStatus);
        builder.in("splitResult", splitResults);
        builder.desc("payTime");
        builder.setPage(page);

        return queryList(builder);
    }

    @Override
    public List<OrgSignupInfo> searchSignupInfoWithCourseInfo(List<Integer> splitResult, List<Integer> payResult,
        List<Integer> payType, Integer signupType, String...queryPropes) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.select(queryPropes);

        if (CollectionUtils.isNotEmpty(splitResult)) {
            builder.in("splitResult", splitResult);
        }

        if (CollectionUtils.isNotEmpty(payResult)) {
            builder.in("purchaseStatus", payResult);
        }

        if (CollectionUtils.isNotEmpty(payType)) {
            builder.in("payType", payType);
        }

        if (signupType != null) {
            builder.eq("signupType", signupType);
        }

        builder.eq("isDel", 0);

        List<OrgSignupInfo> result = queryList(builder);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        List<Long> purchaseIds = Lists.newArrayList();
        for (OrgSignupInfo info : result) {
            purchaseIds.add(info.getSignupPurchaseId());
        }

        List<OrgSignupCourse> signupCourses = orgSignupCourseDao.loadByPurchaseIds(purchaseIds);
        Map<Long, List<OrgSignupCourse>> signupCourseMaping = Maps.newHashMap();

        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            Long purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList<OrgSignupCourse>());
            }
            signupCourseMaping.get(purchaseId).add(orgSignupCourse);
        }

        for (OrgSignupInfo orgSignupInfo : result) {
            Long purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (signupCourseMaping.containsKey(purchaseId)) {
                orgSignupInfo.setOrgSignupCourses(signupCourseMaping.get(purchaseId));
            }
        }
        return result;
    }

    @Override
    public List<OrgSignupInfo> searchByPurchaseIdsWithCourseInfo(@NonNull Collection<Long> purchaseIds,
        String...queryProps) {

        List<OrgSignupInfo> result = searchByPurchaseIds(purchaseIds, queryProps);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }

        List<OrgSignupCourse> signupCourses = orgSignupCourseDao.loadByPurchaseIds(purchaseIds);
        Map<Long, List<OrgSignupCourse>> signupCourseMaping = Maps.newHashMap();

        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            Long purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList<OrgSignupCourse>());
            }
            signupCourseMaping.get(purchaseId).add(orgSignupCourse);
        }

        for (OrgSignupInfo orgSignupInfo : result) {
            Long purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (signupCourseMaping.containsKey(purchaseId)) {
                orgSignupInfo.setOrgSignupCourses(signupCourseMaping.get(purchaseId));
            }
        }
        return result;
    }

    @Override
    public List<OrgSignupInfo> searchByPayPurchaseIdsWithCourseInfo(@NonNull Collection<Long> purchaseIds,
        String...queryProps) {

        List<OrgSignupInfo> result = searchByPayPurchaseIds(purchaseIds, queryProps);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }

        Map<Long, OrgSignupInfo> signupInfoMaps = CollectorUtil.collectMap(result, new Function<OrgSignupInfo, Long>() {
            @Override
            public Long apply(OrgSignupInfo orgSignupInfo) {
                return orgSignupInfo.getSignupPurchaseId();
            }
        });

        List<OrgSignupCourse> signupCourses = orgSignupCourseDao.loadByPurchaseIds(signupInfoMaps.keySet());
        Map<Long, List<OrgSignupCourse>> signupCourseMaping = Maps.newHashMap();

        for (OrgSignupCourse orgSignupCourse : signupCourses) {
            Long purchaseId = orgSignupCourse.getSignupPurchaseId();
            if (!signupCourseMaping.containsKey(purchaseId)) {
                signupCourseMaping.put(purchaseId, new ArrayList<OrgSignupCourse>());
            }
            signupCourseMaping.get(purchaseId).add(orgSignupCourse);
        }

        for (OrgSignupInfo orgSignupInfo : result) {
            Long purchaseId = orgSignupInfo.getSignupPurchaseId();
            if (signupCourseMaping.containsKey(purchaseId)) {
                orgSignupInfo.setOrgSignupCourses(signupCourseMaping.get(purchaseId));
            }
        }
        return result;
    }

    @Override
    public List<Long> getSignupFailPurchaseId() {
        StringBuilder sb = new StringBuilder(
            "select signup_purchase_id from yunying.org_signup_info where purchase_status=1 and user_id = 0 and signup_purchase_id"
                + " in (select signup_purchase_id from yunying.org_signup_course group by signup_purchase_id)");

        return getNamedJdbcTemplate().queryForList(sb.toString(), new HashedMap<String, Object>(), Long.class);
    }

    @Override
    public Long getSignupPriceByDay(Long orgId, String mdate, Integer opType) {
        StringBuilder sb = new StringBuilder(
            "select sum(total_prices) from yunying.org_signup_info where purchase_status=1 and split_result =1 and org_id = :orgId and date_format(pay_time,'%Y-%m-%d') = :mdate and source_type = :opType limit 1");

        Map<String, Object> params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("mdate", mdate);
        params.put("opType", opType);

        return getNamedJdbcTemplate().queryForObject(sb.toString(), params, Long.class);
    }

    @Override
    public Integer countSignupPriceByDay(Long orgId, String mdate, Integer opType) {
        StringBuilder sb = new StringBuilder(
            "select count(total_prices) from yunying.org_signup_info where purchase_status=1 and split_result =1 and org_id = :orgId and date_format(pay_time,'%Y-%m-%d') = :mdate and source_type = :opType limit 1");

        Map<String, Object> params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("mdate", mdate);
        params.put("opType", opType);

        return getNamedJdbcTemplate().queryForObject(sb.toString(), params, Integer.class);
    }

    @Override
    public List<OrgSignupInfo> getSignupSuccessAndNotSync() {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder();
        builder.eq("splitResult", 1);
        builder.eq("purchaseStatus", 1);
        builder.eq("smsSend", 0);
        builder.eq("isDel", DataStatus.NORMAL.getValue());
        builder.le("updateTime", DateUtil.getDiffDateTime(new Date(), -5, 12));// 5分钟前的数据
        log.debug("getSignupSuccessAndNotSync==sql={},params={}", builder.toSql(), builder.collectConditionValue());
        return queryList(builder);
    }

    @Override
    public void updateSignupSmsStatus(Long id, Date updateTime) {
        StringBuilder sb =
            new StringBuilder("update yunying.org_signup_info set sms_send = 1,update_time=:updateTime where id = :id");
        Map params = new HashedMap<String, Object>();
        params.put("id", id);
        params.put("updateTime", updateTime);

        getNamedJdbcTemplate().update(sb.toString(), params);
    }

    @Override
    public void updateSignupFinanceStatus(Long id, Date updateTime) {
        StringBuilder sb = new StringBuilder(
            "update yunying.org_signup_info set finance_sync = 1,update_time=:updateTime where id = :id");
        Map params = new HashedMap<String, Object>();
        params.put("id", id);
        params.put("updateTime", updateTime);

        getNamedJdbcTemplate().update(sb.toString(), params);
    }

    @Override
    public List<OrgSignupInfo> getSignupInfoList(Long orgId, Long userId, Integer status, PageDto pageDto,
        String...queryProps) {
        SingleSqlBuilder<OrgSignupInfo> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("userId", userId);
        builder.eq("isDel", DeleteStatus.NORMAL.getValue());
        if (status != null) {
            if (status.intValue() == WxOrderStatus.FINISH.getCode()) {
                builder.eq("purchaseStatus", PayStatus.SUCESS.getCode());
            } else if (status.intValue() == WxOrderStatus.CANCEL.getCode()) {
                builder.eq("status", DeleteStatus.DELETED.getValue());
            } else if (status.intValue() == WxOrderStatus.NOT_PAY.getCode()) {
                builder.eq("purchaseStatus", PayStatus.PROCESSING.getCode());
                builder.ne("status", DeleteStatus.DELETED.getValue());
            }
        }
        builder.setPage(pageDto);
        builder.desc("createTime");
        return queryList(builder);
    }

    @Override
    public Map<Date, Double> getOrderMap(Long orgId, Date start, Date end) {
        Preconditions.checkArgument(start != null && end != null && start.before(end), "时间范围错误");
        Map<String, Object> param = new HashMap<>();
        param.put("orgId", orgId);
        String sql =
            "select SUM(total_prices) amount, DATE_FORMAT(pay_time,'%Y-%m-%d') payTime from yunying.org_signup_info where org_id = (:orgId) and is_del = 0 and purchase_status = 1";
        if (start != null && end != null) {
            sql += " and create_time between :startDate and :endDate";
            param.put("endDate", end);
            param.put("startDate", start);
        }
        sql += " group by payTime";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Date, Double>>() {
            @Override
            public Map<Date, Double> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Date, Double> map = new HashMap<>();
                while (rs.next()) {
                    map.put(DateUtil.getDateByStr(rs.getString("payTime")), rs.getLong("amount") / 100D);
                }
                return map;
            }
        });
    }
}
