
package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.dal.signup.dao.OrgSignupFeeDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupFee;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.BatchQueryTemplate;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.collect.Maps;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.*;

@Repository
public class OrgSignupFeeDaoImpl extends JdbcTemplateDaoSupport<OrgSignupFee> implements OrgSignupFeeDao {

    public OrgSignupFeeDaoImpl() {
        super(OrgSignupFee.class);
    }


    @Override
    public List<OrgSignupFee> loadByPurchaseIds(@NonNull Collection<Long> purchaseIds, final String... queryProps) {
        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyList();
        }
        BatchQueryTemplate<Long, List<OrgSignupFee>> queryTemplate = new ListBatchQueryTemplate<>();
        return queryTemplate.batchQuery(purchaseIds, new BatchQueryCallback<Long, List<OrgSignupFee>>() {
            @Override
            public List<OrgSignupFee> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder<OrgSignupFee> builder = createSqlBuilder();
                builder.select(queryProps);
                builder.in("signupPurchaseId", querySet);
                return queryList(builder);
            }
        });
    }

    @Override
    public List<OrgSignupFee> loadByPurchaseId(@NonNull Long purchaseId, String... queryProps) {
        SingleSqlBuilder<OrgSignupFee> builder = createSqlBuilder();
        builder.select(queryProps);
        builder.eq("signupPurchaseId", purchaseId);
        return queryList(builder);

    }

    @Override
    public void saveOrUpdateSignupFee(@NonNull OrgSignupFee signupFee) {
        if (signupFee.getId() > 0) {
            update(signupFee);
        } else {
            save(signupFee);
        }
    }


    @Override
    public void saveSignupFees(List<OrgSignupFee> fees) {
        saveAll(fees);
    }

}
