package com.baijia.tianxiao.dal.signup.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/6/30 Time: 下午6:24 To change this template use File | Settings
 * | File Templates.
 */
public interface OrgSignupRefundDao extends CommonDao<OrgSignupRefund> {

    List<OrgSignupRefund> getOrgSignupRefundListByMinId(Long minId, Date lastDate, int maxSize, String... queryProps);

    List<OrgSignupRefund> getOrgSignupRefundListByPurchaseId(Long orgId, Long purchaseId, Long courseId);

    List<OrgSignupRefund> getOrgSignupRefundByStudent(Long orgId, Long purchaseId, Long userId, Long courseId);

    int getRefundTime(Long orgId, Long signupPurchaseId, Long courseId);

    List<OrgSignupRefund> getByPurcahseIds(Set<Long> purchaseIds);

    List<Integer> listIdsByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime, Date endTime);

    List<OrgSignupRefund> listByUserId(Long orgId, Collection<Long> classIds, Long userId, Date startTime,
                                       Date endTime);

    List<Integer> listIdsByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime, Date endTime);

    List<OrgSignupRefund> listByClassId(Long orgId, Long classId, Collection<Long> userIds, Date startTime,
                                        Date endTime);

    List<Integer> listIdsByClassIds(Collection<Long> classIds, Date startTime, Date endTime);

    List<OrgSignupRefund> listByClassIds(Collection<Long> classIds, Date startTime, Date endTime);

    List<OrgSignupRefund> listByOrgId(Long orgId, Collection<Long> classIds, Collection<Long> userIds, Date startTime,
                                      Date endTime);

    Long sumRefundFeeByOrgId(Long orgId, Date startTime, Date endTime);

    Long sumRefundFeeByClassId(Long orgId, Long classId);

    Long sumRefundFeeByUserId(Long orgId, Long userId);

    Long sumRefundFeeByClassIds(Collection<Long> classIds, Date startTime, Date endTime);

    Long sumRefundFeeByUserIds(Long orgId, Collection<Long> userIds, Date startTime, Date endTime);

    Long sumRefundFeeByOrgIds(Collection<Long> orgIds, Date startTime, Date endTime);

    Map<Long, Long> mapRefundFeeByOrgIds(Collection<Long> orgIds, Date startTime, Date endTime);

    Map<Long, Long> mapRefundFeeByClassIds(Collection<Long> classIds, Date startTime, Date endTime);

    Map<Long, Long> mapRefundFeeByUserIds(Long orgId, Collection<Long> userIds, Date startTime, Date endTime);

    public void syncRealCourseId(Collection<String> syncDatas);

    List<Long> pageDistinctClassId(Long orgId, Collection<Long> classIds, Date startTime, Date endTime,
                                   PageDto pageDto);

    List<Long> pageDistinctUserId(Long orgId, Collection<Long> userIds, Date startTime, Date endTime, PageDto pageDto);

    List<OrgSignupRefund> pageByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime,
                                         PageDto pageDto);

    Integer countByClassIds(Long orgId, Collection<Long> classIds, Date startTime, Date endTime);

    /**
     * @param orgId
     * @param userIds
     * @return
     */
    Map<String, Long> sumRefundMoney(Long orgId, Collection<Long> courseIds, Collection<Long> userIds);

    List<OrgSignupRefund> listOrderByCreateTime(List<Integer> ids);

    List<OrgSignupRefund> listOrderByUserIds(Long orgId, Collection<Long> userIds);

    List<OrgSignupRefund> listOrderByUserIdAndCourseId(Long orgId, Long userId,Long classId);

    List<OrgSignupRefund> listOrderByUserIdsAndCourseId(Long orgId, Collection<Long> userIds,Long courseId);

}
