package com.baijia.tianxiao.dal.signup.dao;

import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @Author liuxiaopeng
 */
public interface OrgSignupCourseLessonDao extends CommonDao<OrgSignupCourseLesson> {
    public Map<Long, OrgSignupCourseLesson> selectSignUpLessons(Collection<Long> userIds,Long lessonId,Long orgId);

    /**
     * 查询排课信息
     * @return
     */
    public Map<String, OrgSignupCourseLesson> selectLessonInfoMap(Long orgId,Collection<Long> lessonIds,Collection<Long> userIds);

    /**
     *
     * @param orgId
     * @param lessonIds
     * @param userIds
     * @return
     */
    public List<OrgSignupCourseLesson> getLessonList(Long orgId,Collection<Long> lessonIds,Collection<Long> userIds);

    /**
     * 删除课节
     * @param orgId
     * @param lessonIds
     */
    public void batchDelLesson(long orgId, Collection<Long> lessonIds);

    /**
     * 删除课节学生
     * @param orgId
     * @param userIds
     */
    public void batchDelStuLesson(long orgId, Collection<Long> userIds,Collection<Long> lessonIds);
    /**
     * 批量取消课节
     * @param orgId
     * @param lessonId
     * @param userIds
     */
    public void batchCancelLesson(Long orgId,Long lessonId,Collection<Long> userIds);

    public void batchUpdateLessonDuration(Long orgId,Long lessonId,Collection<Long> userIds,long lessonDuration);

    /**
     * 批量更新课消状态
     * @param lessonIds
     * @param userIds
     * @param kexiaoStatus
     */
    public void batchUpdateKexiaoStatus(Collection<Long> lessonIds,Collection<Long> userIds,int kexiaoStatus);

    /**
     * 按班级统计学院排课时间
     * @param orgId
     * @param classId
     * @param userIds
     * @param lessonType
     * @return
     */
    public Map<Long, OrgSignupCourseLesson> selectLessonInfoByClassId(Long orgId,Long classId,Collection<Long> userIds,Integer lessonType);

    /**
     * 按用户和班级查询
     * @param orgId
     * @param userId
     * @param classId
     * @param lessonType
     * @param kexiaoStatus
     * @return
     */
    public List<OrgSignupCourseLesson> listLessonsByUserIdAndClassId(Long orgId,Long userId,Long classId,Integer lessonType,Integer kexiaoStatus);

    /**
     * 查询订单已课消的金额
     * @param signupCourseIds
     * @param status
     * @return
     */
    public List<OrgSignupCourseLesson> listBySignupCourseIds(Collection<Long> signupCourseIds,Integer lessonType,Integer status);

    public Map<String, OrgSignupCourseLesson> listBySignupCourseIdAndLessonId(Collection<Long> signupCourseIds, Collection<Long> lessonIds);
    /**
    * 分页查询机构数据
     * @param orgId
     * @param page
     * @param props
     * @return
     */
    public List<OrgSignupCourseLesson> listByOrg(Long orgId, PageDto page,String ...props);

    /**
     * 查询用户课节对应的课次/课时信息
     * @param userIds
     * @param lessonIds
     * @return
     */
    public List<OrgSignupCourseLesson> listByUserIdAndLessonId(Collection<Long> userIds, Collection<Long> lessonIds, Integer kexiaoStatus);

    /**
     * 查询用户班级对应的课次/课时信息
     * @param userIds
     * @param classId
     * @return
     */
    public List<OrgSignupCourseLesson> listByUserIdsAndClassId(Collection<Long> userIds, long classId, Integer kexiaoStatus);
}
