package com.baijia.tianxiao.dal.signup.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.signup.dto.OrgStudentSignupStatistics;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/*
 * 
 * @title OrgSignupCourseDao
 * 
 * @desc TODO
 * 
 * @author shizuwei
 * 
 * @date 2015年12月4日
 * 
 * @version 1.0
 */
public interface OrgSignupCourseDao extends CommonDao<OrgSignupCourse> {
    /**
     * 根据课程号查询订单ID列表
     */
    List<Long> searchPurchaseIdByCourseId(Collection<Long> courseIds, Date startTime, Date endTime);

    /**
     * 根据订单ID查询报名课程
     */
    List<OrgSignupCourse> loadByPurchaseIds(Collection<Long> purchaseIds, String... queryProps);

    void saveOrUpdateSignupCourse(OrgSignupCourse signupCourse);

    void saveSignupCourses(List<OrgSignupCourse> courses);

    List<OrgSignupCourse> loadByPurchaseId(Long purchaseId, String... queryProps);

    OrgSignupCourse getByCourseId(Long orgId, Long purchaseId, Long courseId);

    List<OrgSignupCourse> searchByUserIdsAndClassId(Collection<Long> userIds, Long courseId, Long orgId, Collection<Integer> status);

    List<OrgSignupCourse> getByCourseIdsAndStudentId(Long orgId, Long userId, Collection<Long> courseIds, Collection<Integer> status);

    List<OrgSignupCourse> getByCourseIdAndStudentId(Long orgId, Long userId, Long courseId,
                                                    Collection<Integer> status);

    int updateStatusByPurchaseId(Long signupPurchaseId, Long orgCourseId, Long userId, Integer status);

    int updateStatusByPurchaseId(Long signupPurchaseId, Integer status);

    int updateLessonCountByPurchaseId(Long signupPurchaseId, Long orgCourseId);

    void delSignupCourseByPurchaseId(Long signupPurchaseId);

    int reSyncLessonCount(List<Long> purchaseIds);

    List<OrgSignupCourse> getByCourseIdsAndStudentIds(Collection<Long> delUserIds, Long orgId, Collection<Long> classIds,
                                                      Collection<Long> userIds, Integer supplement, PageDto pageDto, String... props);

    List<OrgSignupCourse> getByCourseIdsAndStudentIds(Collection<Long> orgIds, Collection<Long> courseIds,
                                                      Collection<Long> userIds, String... props);

    Map<Long, Object> getSignupedCourseIdsByStudentId(Long orgId, Long userId);

    Map<Long, Object> getSignupedUserIdsByCourseId(Long orgId, Long courseId);

    List<OrgSignupCourse> getByCourseIdsAndStudentIds(Long orgId, Collection<Integer> ids, Collection<Long> courseIds,
                                                      Collection<Long> userIds, String... props);

    Map<Long, Integer> getCourseStudentCountMap(Collection<Long> delUserIds, Long orgId, List<Long> courseIds, Integer supplement);

    /**
     * @param orgId
     * @param userIds
     * @param courseIds
     * @return
     */
    Map<Long, Boolean> canShowTotalCount(Long orgId, Collection<Long> userIds, Collection<Long> courseIds);

    /**
     * @param orgId
     * @param userIds
     * @param courseIds
     * @return
     */
    List<OrgStudentSignupStatistics> findAllOrgStudentSignupStatistics(Long orgId, Collection<Long> userIds,
                                                                       Collection<Long> courseIds);

    Map<Long, OrgSignupCourse> mapKeyClassId(Long orgId, Long userId);

    Map<Long, OrgSignupCourse> mapKeyUserId(Long orgId, Long classId);

    List<OrgSignupCourse> listByUserId(Long orgId, Collection<Long> classIds, Long userId);

    List<OrgSignupCourse> listByClassId(Long orgId, Long classId, Collection<Long> userIds, List<Integer> status);


    /**
     * @param orgId
     * @param orgCourseId
     * @param userId
     * @param props
     * @return
     */
    List<OrgSignupCourse> getLeftQuitClassSignupCourse(Long orgId, Long orgCourseId, Long userId, Long signupPurchaseId, String... props);

    List<OrgSignupCourse> listSignupCourseByCourse(Long orgId, Long signupPurchaseId, Long orgCourseId, Long userId, String... props);

    List<Long> getClassIds(Collection<Long> delUserIds, Collection<Long> notInCourseIds, Long orgId, Collection<Long> courseNameClassIds, Integer supplement, PageDto pageDto);

    /**
     * @param syncDatas
     */
    void syncRealCourseId(Collection<String> syncDatas);


    List<OrgSignupCourse> getCousePurchaseListByMinId(Long minId, Date lastDate, int maxSize, List<Integer> notStatus, String... queryProps);

    int sumAllLessonCount(Long orgId, Long orgCourseId, Long userId, List<Integer> status, String... queryProps);

    /**
     * 课程已买订单数
     *
     * @param orgId
     * @param courseId
     * @param statusArr : 0报名未支付、1取消、2报名支付成功、3退班
     * @return
     */
    int getSignupCourseCount(Long orgId, Long courseId, Collection<Integer> statusArr);

    /**
     * @param afterOverRecordId
     * @param lastId
     * @return
     */
    List<OrgSignupCourse> listAllNeedSyncRecordWithRange(int afterOverRecordId, int lastId);

    /**
     * @return
     */
    int selectMaxId();

    List<OrgSignupCourse> listByPurchaseIds(Collection<Long> purchaseIds,Long classId, String... queryProps);

    /**
     * 重新同步订单列表
     * @param signupPurchaseId
     * @param orgCourseId
     * @param userId
     * @return
     */
    int resyncLesson(Long signupPurchaseId, Long orgCourseId, Long userId);
}
