/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.signup.constant;

import lombok.Getter;

public enum TransferClassOrder {

    ALL(-1, "所有"),

    NORMAL_ORDER(0, "直接报名"),

    TRANSFER_ORDER(1, "转班报名"),;

    @Getter
    private int code;
    @Getter
    private String name;

    TransferClassOrder(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(int code) {
        for (TransferClassOrder transferClassOrder : TransferClassOrder.values()) {
            if (code == transferClassOrder.getCode()) {
                return transferClassOrder.getName();
            }
        }
        return "";
    }

}
