/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.signup.constant;

import java.util.Map;

import com.google.common.collect.Maps;

public enum SignupType {

    POS_CARD(0, "刷卡报名"),

    FRONTED(1, "前台报名"),

    ONLINE(2, "在线报名"),

    ;

    private int code;

    private String note;

    private static Map<Integer, SignupType> map = Maps.newHashMap();

    private SignupType(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (SignupType type : SignupType.values()) {
            map.put(type.code, type);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static SignupType getTypeByCode(Integer code) {
        return map.get(code);
    }

}
