package com.baijia.tianxiao.dal.signup.constant;

import java.util.Map;

import com.google.common.collect.Maps;

public enum SignupStatus {

    ALL(0, "全部"),

    FINISHED(1, "已完成"),

    NOT_PAY(2, "待收款"),

    NOT_SIGN(3, "待报名"),

    CANCEL(4, "取消报名");

    private int code;

    private String note;

    private static Map<Integer, SignupStatus> map = Maps.newHashMap();

    SignupStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (SignupStatus signupStatus : SignupStatus.values()) {
            map.put(signupStatus.code, signupStatus);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static SignupStatus getPayTypeByCode(Integer code) {
        return map.get(code);
    }
}
