package com.baijia.tianxiao.dal.signup.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum SignupCourseStatus {

    INIT(-1, "历史数据初始化"),

    NOT_PAY(0, "待收款"),

    CANCEL(1, "取消"),

    HAS_PAY(2, "报名支付完成"),

    HAS_ADD(3, "系统补充课消"),

    IMPORT(4, "Excel导入课消"),

    QUIT_PURCHASE(5, "退单"),

    QUIT_CLASS(6, "退班"),;

    private int code;

    private String note;

    private static Map<Integer, SignupCourseStatus> map = Maps.newHashMap();

    public static List<Integer> syncLessconCount = Lists.newArrayList();//是否需要同步合同课次

    public static List<Integer> inClassStatus = Lists.newArrayList();//是否在班且没有退班

    public static List<Integer> inStudentCourseStatus = Lists.newArrayList();//是否在班,包括退班的

    public static List<Integer> quitClassStatus = Lists.newArrayList();//退班和退单状态

    public static final Set<Integer> VALIDATE_STATS = new HashSet<>();

    public static final Set<Integer> PAY_SUCCESS = new HashSet<>();

    static {
        syncLessconCount.add(HAS_PAY.code);
        syncLessconCount.add(HAS_ADD.code);
        syncLessconCount.add(IMPORT.code);
        syncLessconCount.add(QUIT_PURCHASE.code);
        syncLessconCount.add(QUIT_CLASS.code);
    }

    static {
        inClassStatus.add(INIT.code);
        inClassStatus.add(HAS_PAY.code);
        inClassStatus.add(HAS_ADD.code);
        inClassStatus.add(IMPORT.code);
    }

    static {
        VALIDATE_STATS.add(HAS_PAY.code);
        VALIDATE_STATS.add(HAS_ADD.code);
        VALIDATE_STATS.add(IMPORT.code);

        PAY_SUCCESS.add(HAS_PAY.code);
        PAY_SUCCESS.add(HAS_ADD.code);
        PAY_SUCCESS.add(IMPORT.code);
        PAY_SUCCESS.add(QUIT_PURCHASE.code);
        PAY_SUCCESS.add(QUIT_CLASS.code);
    }

    static {
        quitClassStatus.add(QUIT_PURCHASE.getCode());
        quitClassStatus.add(QUIT_CLASS.getCode());
    }

    static {
        inStudentCourseStatus.addAll(inClassStatus);
        inStudentCourseStatus.addAll(quitClassStatus);
    }

    SignupCourseStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (SignupCourseStatus signupStatus : SignupCourseStatus.values()) {
            map.put(signupStatus.code, signupStatus);
        }
    }

    public static List<Integer> purchaseInStudentCourse() {
        return inClassStatus;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static SignupCourseStatus getStatusByCode(Integer code) {
        return map.get(code);
    }

    public static boolean statusInClass(int code) {
        return inClassStatus.contains(code);
    }

    public static boolean statusInStudentCourse(int code) {
        return inStudentCourseStatus.contains(code);
    }

    public static boolean statusInQuitCourse(int code) {
        return quitClassStatus.contains(code);
    }

    public static boolean statusSyncLessconCount(int code) {
        return syncLessconCount.contains(code);
    }

    public static void main(String[] args) {
        System.out.println(statusInClass(-1));
    }

}
