
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.show.dao.impl;

import com.baijia.tianxiao.dal.show.dao.OrgShowInfoDao;
import com.baijia.tianxiao.dal.show.po.OrgShowInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

/**
 * @title OrgShowInfoDaoImpl
 * @desc TODO
 * @author shanyu
 * @date 2016年3月11日
 * @version 1.0
 */
@Repository("orgShowInfoDao")
public class OrgShowInfoDaoImpl extends JdbcTemplateDaoSupport<OrgShowInfo> implements OrgShowInfoDao {

    public OrgShowInfoDaoImpl() {
        super(OrgShowInfo.class);
    }
    
    @Override
    public OrgShowInfo getShowInfo(Long orgId, Integer type, String...queryProps) {
        SingleSqlBuilder<OrgShowInfo> builder = createSqlBuilder(queryProps);
        builder.eq("orgId", orgId);
        builder.eq("type", type);
        return uniqueResult(builder);
    }

}
